/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.execute;

import com.google.common.collect.Lists;
import java.sql.ParameterMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.phoenix.compile.ExplainPlan;
import org.apache.phoenix.compile.GroupByCompiler;
import org.apache.phoenix.compile.OrderByCompiler;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.compile.RowProjector;
import org.apache.phoenix.compile.ScanRanges;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.iterate.DelegateResultIterator;
import org.apache.phoenix.iterate.ParallelIterators;
import org.apache.phoenix.iterate.ResultIterator;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.parse.FilterableStatement;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.util.SQLCloseable;
import org.apache.phoenix.util.SQLCloseables;
import org.apache.phoenix.util.ScanUtil;

public abstract class BasicQueryPlan
implements QueryPlan {
    protected static final long DEFAULT_ESTIMATED_SIZE = 10240L;
    protected final TableRef tableRef;
    protected final StatementContext context;
    protected final FilterableStatement statement;
    protected final RowProjector projection;
    protected final ParameterMetaData paramMetaData;
    protected final Integer limit;
    protected final OrderByCompiler.OrderBy orderBy;
    protected final GroupByCompiler.GroupBy groupBy;
    protected final ParallelIterators.ParallelIteratorFactory parallelIteratorFactory;

    protected BasicQueryPlan(StatementContext context, FilterableStatement statement, TableRef table, RowProjector projection, ParameterMetaData paramMetaData, Integer limit, OrderByCompiler.OrderBy orderBy, GroupByCompiler.GroupBy groupBy, ParallelIterators.ParallelIteratorFactory parallelIteratorFactory) {
        this.context = context;
        this.statement = statement;
        this.tableRef = table;
        this.projection = projection;
        this.paramMetaData = paramMetaData;
        this.limit = limit;
        this.orderBy = orderBy;
        this.groupBy = groupBy;
        this.parallelIteratorFactory = parallelIteratorFactory;
    }

    @Override
    public boolean isDegenerate() {
        return this.context.getScanRanges() == ScanRanges.NOTHING;
    }

    @Override
    public GroupByCompiler.GroupBy getGroupBy() {
        return this.groupBy;
    }

    @Override
    public OrderByCompiler.OrderBy getOrderBy() {
        return this.orderBy;
    }

    @Override
    public TableRef getTableRef() {
        return this.tableRef;
    }

    @Override
    public Integer getLimit() {
        return this.limit;
    }

    @Override
    public RowProjector getProjector() {
        return this.projection;
    }

    @Override
    public final ResultIterator iterator() throws SQLException {
        return this.iterator(Collections.<SQLCloseable>emptyList());
    }

    public final ResultIterator iterator(final List<SQLCloseable> dependencies) throws SQLException {
        if (this.context.getScanRanges() == ScanRanges.NOTHING) {
            return ResultIterator.EMPTY_ITERATOR;
        }
        Scan scan = this.context.getScan();
        PhoenixConnection connection = this.context.getConnection();
        Long scn = connection.getSCN();
        ScanUtil.setTimeRange(scan, scn == null ? this.context.getCurrentTime() : scn.longValue());
        ScanUtil.setTenantId(scan, connection.getTenantId() == null ? null : connection.getTenantId().getBytes());
        ResultIterator iterator = this.newIterator();
        return dependencies.isEmpty() ? iterator : new DelegateResultIterator(iterator){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() throws SQLException {
                try {
                    super.close();
                }
                finally {
                    SQLCloseables.closeAll(dependencies);
                }
            }
        };
    }

    protected abstract ResultIterator newIterator() throws SQLException;

    @Override
    public long getEstimatedSize() {
        return 10240L;
    }

    @Override
    public ParameterMetaData getParameterMetaData() {
        return this.paramMetaData;
    }

    @Override
    public FilterableStatement getStatement() {
        return this.statement;
    }

    @Override
    public StatementContext getContext() {
        return this.context;
    }

    @Override
    public ExplainPlan getExplainPlan() throws SQLException {
        if (this.context.getScanRanges() == ScanRanges.NOTHING) {
            return new ExplainPlan(Collections.singletonList("DEGENERATE SCAN OVER " + this.tableRef.getTable().getName().getString()));
        }
        QueryPlan plan = this.context.getConnection().getQueryServices().getOptimizer().optimize(this.context.getStatement(), this);
        ResultIterator iterator = plan.iterator();
        ArrayList<String> planSteps = Lists.newArrayListWithExpectedSize(5);
        iterator.explain(planSteps);
        return new ExplainPlan(planSteps);
    }
}

