/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.execute;

import com.google.common.collect.Lists;
import java.sql.ParameterMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.phoenix.cache.ServerCacheClient;
import org.apache.phoenix.compile.ExplainPlan;
import org.apache.phoenix.compile.GroupByCompiler;
import org.apache.phoenix.compile.OrderByCompiler;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.compile.RowProjector;
import org.apache.phoenix.compile.ScanRanges;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.execute.BasicQueryPlan;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.iterate.ResultIterator;
import org.apache.phoenix.job.JobManager;
import org.apache.phoenix.join.HashCacheClient;
import org.apache.phoenix.join.HashJoinInfo;
import org.apache.phoenix.parse.FilterableStatement;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.query.KeyRange;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.util.SQLCloseable;
import org.apache.phoenix.util.SQLCloseables;

public class HashJoinPlan
implements QueryPlan {
    private static final Log LOG = LogFactory.getLog(HashJoinPlan.class);
    private BasicQueryPlan plan;
    private HashJoinInfo joinInfo;
    private List<Expression>[] hashExpressions;
    private QueryPlan[] hashPlans;

    public HashJoinPlan(BasicQueryPlan plan, HashJoinInfo joinInfo, List<Expression>[] hashExpressions, QueryPlan[] hashPlans) {
        this.plan = plan;
        this.joinInfo = joinInfo;
        this.hashExpressions = hashExpressions;
        this.hashPlans = hashPlans;
    }

    @Override
    public Integer getLimit() {
        return this.plan.getLimit();
    }

    @Override
    public OrderByCompiler.OrderBy getOrderBy() {
        return this.plan.getOrderBy();
    }

    @Override
    public RowProjector getProjector() {
        return this.plan.getProjector();
    }

    @Override
    public ResultIterator iterator() throws SQLException {
        ImmutableBytesPtr[] joinIds = this.joinInfo.getJoinIds();
        assert (joinIds.length == this.hashExpressions.length && joinIds.length == this.hashPlans.length);
        final HashCacheClient hashClient = new HashCacheClient(this.plan.getContext().getConnection());
        Scan scan = this.plan.getContext().getScan();
        final ScanRanges ranges = this.plan.getContext().getScanRanges();
        int count = joinIds.length;
        ConnectionQueryServices services = this.getContext().getConnection().getQueryServices();
        ExecutorService executor = services.getExecutor();
        ArrayList<Future<ServerCacheClient.ServerCache>> futures = new ArrayList<Future<ServerCacheClient.ServerCache>>(count);
        ArrayList<SQLCloseable> dependencies = new ArrayList<SQLCloseable>(count);
        final int maxServerCacheTimeToLive = services.getProps().getInt("phoenix.coprocessor.maxServerCacheTimeToLiveMs", 30000);
        final AtomicLong firstJobEndTime = new AtomicLong(0L);
        SQLException firstException = null;
        int i = 0;
        while (i < count) {
            final int index = i++;
            futures.add(executor.submit(new JobManager.JobCallable<ServerCacheClient.ServerCache>(){

                @Override
                public ServerCacheClient.ServerCache call() throws Exception {
                    QueryPlan hashPlan = HashJoinPlan.this.hashPlans[index];
                    ServerCacheClient.ServerCache cache = hashClient.addHashCache(ranges, hashPlan.iterator(), hashPlan.getEstimatedSize(), HashJoinPlan.this.hashExpressions[index], HashJoinPlan.this.plan.getTableRef());
                    long endTime = System.currentTimeMillis();
                    boolean isSet = firstJobEndTime.compareAndSet(0L, endTime);
                    if (!isSet && endTime - firstJobEndTime.get() > (long)maxServerCacheTimeToLive) {
                        LOG.warn("Hash plan [" + index + "] execution seems too slow. Earlier hash cache(s) might have expired on servers.");
                    }
                    return cache;
                }

                @Override
                public Object getJobId() {
                    return HashJoinPlan.this;
                }
            }));
        }
        for (i = 0; i < count; ++i) {
            try {
                ServerCacheClient.ServerCache cache = (ServerCacheClient.ServerCache)((Future)futures.get(i)).get();
                joinIds[i].set(cache.getId());
                dependencies.add(cache);
                continue;
            }
            catch (InterruptedException e) {
                if (firstException != null) continue;
                firstException = new SQLException("Hash plan [" + i + "] execution interrupted.", e);
                continue;
            }
            catch (ExecutionException e) {
                if (firstException != null) continue;
                firstException = new SQLException("Encountered exception in hash plan [" + i + "] execution.", e.getCause());
            }
        }
        if (firstException != null) {
            SQLCloseables.closeAllQuietly(dependencies);
            throw firstException;
        }
        HashJoinInfo.serializeHashJoinIntoScan(scan, this.joinInfo);
        return this.plan.iterator(dependencies);
    }

    @Override
    public long getEstimatedSize() {
        return this.plan.getEstimatedSize();
    }

    @Override
    public List<KeyRange> getSplits() {
        return this.plan.getSplits();
    }

    @Override
    public ExplainPlan getExplainPlan() throws SQLException {
        List<String> mainQuerySteps = this.plan.getExplainPlan().getPlanSteps();
        ArrayList<String> planSteps = Lists.newArrayList(mainQuerySteps);
        int count = this.hashPlans.length;
        planSteps.add("    PARALLEL EQUI-JOIN " + count + " HASH TABLES:");
        for (int i = 0; i < count; ++i) {
            boolean earlyEvaluation = this.joinInfo.earlyEvaluation()[i];
            boolean skipMerge = this.joinInfo.getSchemas()[i].getFieldCount() == 0;
            planSteps.add("    BUILD HASH TABLE " + i + (earlyEvaluation ? "" : "(DELAYED EVALUATION)") + (skipMerge ? " (SKIP MERGE)" : ""));
            List<String> steps = this.hashPlans[i].getExplainPlan().getPlanSteps();
            for (String step : steps) {
                planSteps.add("        " + step);
            }
        }
        if (this.joinInfo.getPostJoinFilterExpression() != null) {
            planSteps.add("    AFTER-JOIN SERVER FILTER BY " + this.joinInfo.getPostJoinFilterExpression().toString());
        }
        return new ExplainPlan(planSteps);
    }

    @Override
    public ParameterMetaData getParameterMetaData() {
        return this.plan.getParameterMetaData();
    }

    @Override
    public StatementContext getContext() {
        return this.plan.getContext();
    }

    @Override
    public GroupByCompiler.GroupBy getGroupBy() {
        return this.plan.getGroupBy();
    }

    @Override
    public TableRef getTableRef() {
        return this.plan.getTableRef();
    }

    @Override
    public FilterableStatement getStatement() {
        return this.plan.getStatement();
    }

    @Override
    public boolean isDegenerate() {
        return false;
    }
}

