/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.execute;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.UnmodifiableIterator;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.cache.ServerCacheClient;
import org.apache.phoenix.coprocessor.MetaDataProtocol;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.execute.CommitException;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.index.IndexMaintainer;
import org.apache.phoenix.index.IndexMetaDataCacheClient;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.schema.IllegalDataException;
import org.apache.phoenix.schema.MetaDataClient;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.PRow;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableKey;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.IndexUtil;
import org.apache.phoenix.util.SQLCloseable;
import org.apache.phoenix.util.ServerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MutationState
implements SQLCloseable {
    private static final Logger logger = LoggerFactory.getLogger(MutationState.class);
    private PhoenixConnection connection;
    private final long maxSize;
    private final ImmutableBytesPtr tempPtr = new ImmutableBytesPtr();
    private final Map<TableRef, Map<ImmutableBytesPtr, Map<PColumn, byte[]>>> mutations = Maps.newHashMapWithExpectedSize(3);
    private final long sizeOffset;
    private int numRows = 0;

    public MutationState(int maxSize, PhoenixConnection connection) {
        this(maxSize, connection, 0L);
    }

    public MutationState(int maxSize, PhoenixConnection connection, long sizeOffset) {
        this.maxSize = maxSize;
        this.connection = connection;
        this.sizeOffset = sizeOffset;
    }

    public MutationState(TableRef table, Map<ImmutableBytesPtr, Map<PColumn, byte[]>> mutations, long sizeOffset, long maxSize, PhoenixConnection connection) {
        this.maxSize = maxSize;
        this.connection = connection;
        this.mutations.put(table, mutations);
        this.sizeOffset = sizeOffset;
        this.numRows = mutations.size();
        this.throwIfTooBig();
    }

    private MutationState(List<Map.Entry<TableRef, Map<ImmutableBytesPtr, Map<PColumn, byte[]>>>> entries, long sizeOffset, long maxSize, PhoenixConnection connection) {
        this.maxSize = maxSize;
        this.connection = connection;
        this.sizeOffset = sizeOffset;
        for (Map.Entry<TableRef, Map<ImmutableBytesPtr, Map<PColumn, byte[]>>> entry : entries) {
            this.numRows += entry.getValue().size();
            this.mutations.put(entry.getKey(), entry.getValue());
        }
        this.throwIfTooBig();
    }

    private void throwIfTooBig() {
        if ((long)this.numRows > this.maxSize) {
            throw new IllegalArgumentException("MutationState size of " + this.numRows + " is bigger than max allowed size of " + this.maxSize);
        }
    }

    public long getUpdateCount() {
        return this.sizeOffset + (long)this.numRows;
    }

    public void join(MutationState newMutation) {
        if (this == newMutation) {
            return;
        }
        for (Map.Entry<TableRef, Map<ImmutableBytesPtr, Map<PColumn, byte[]>>> entry : newMutation.mutations.entrySet()) {
            Map<ImmutableBytesPtr, Map<PColumn, byte[]>> existingRows = this.mutations.put(entry.getKey(), entry.getValue());
            if (existingRows != null) {
                for (Map.Entry<ImmutableBytesPtr, Map<PColumn, byte[]>> rowEntry : entry.getValue().entrySet()) {
                    Map<PColumn, byte[]> existingValues = existingRows.put(rowEntry.getKey(), rowEntry.getValue());
                    if (existingValues != null) {
                        Map<PColumn, byte[]> newRow;
                        if (existingValues == PRow.DELETE_MARKER || (newRow = rowEntry.getValue()) == PRow.DELETE_MARKER) continue;
                        for (Map.Entry<PColumn, byte[]> valueEntry : newRow.entrySet()) {
                            existingValues.put(valueEntry.getKey(), valueEntry.getValue());
                        }
                        existingRows.put(rowEntry.getKey(), existingValues);
                        continue;
                    }
                    ++this.numRows;
                }
                this.mutations.put(entry.getKey(), existingRows);
                continue;
            }
            this.numRows += entry.getValue().size();
        }
        this.throwIfTooBig();
    }

    private Iterator<Pair<byte[], List<Mutation>>> addRowMutations(final TableRef tableRef, Map<ImmutableBytesPtr, Map<PColumn, byte[]>> values, long timestamp, boolean includeMutableIndexes) {
        final ArrayList<Mutation> mutations = Lists.newArrayListWithExpectedSize(values.size());
        for (Map.Entry<ImmutableBytesPtr, Map<PColumn, byte[]>> rowEntry : values.entrySet()) {
            ImmutableBytesPtr key = rowEntry.getKey();
            PRow row = tableRef.getTable().newRow(this.connection.getKeyValueBuilder(), timestamp, key, (byte[][])new byte[0][]);
            if (rowEntry.getValue() == PRow.DELETE_MARKER) {
                row.delete();
            } else {
                for (Map.Entry<PColumn, byte[]> valueEntry : rowEntry.getValue().entrySet()) {
                    row.setValue(valueEntry.getKey(), valueEntry.getValue());
                }
            }
            mutations.addAll(row.toRowMutations());
        }
        final UnmodifiableIterator indexes = tableRef.getTable().isImmutableRows() || includeMutableIndexes ? IndexMaintainer.nonDisabledIndexIterator(tableRef.getTable().getIndexes().iterator()) : Iterators.emptyIterator();
        return new Iterator<Pair<byte[], List<Mutation>>>(){
            boolean isFirst = true;

            @Override
            public boolean hasNext() {
                return this.isFirst || indexes.hasNext();
            }

            @Override
            public Pair<byte[], List<Mutation>> next() {
                List<Mutation> indexMutations;
                if (this.isFirst) {
                    this.isFirst = false;
                    return new Pair<byte[], List<Mutation>>(tableRef.getTable().getPhysicalName().getBytes(), mutations);
                }
                PTable index = (PTable)indexes.next();
                try {
                    indexMutations = IndexUtil.generateIndexData(tableRef.getTable(), index, mutations, MutationState.this.tempPtr, MutationState.this.connection.getKeyValueBuilder());
                }
                catch (SQLException e) {
                    throw new IllegalDataException(e);
                }
                return new Pair<byte[], List<Mutation>>(index.getPhysicalName().getBytes(), indexMutations);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Iterator<Pair<byte[], List<Mutation>>> toMutations() {
        return this.toMutations(false);
    }

    public Iterator<Pair<byte[], List<Mutation>>> toMutations(final boolean includeMutableIndexes) {
        final Iterator<Map.Entry<TableRef, Map<ImmutableBytesPtr, Map<PColumn, byte[]>>>> iterator = this.mutations.entrySet().iterator();
        if (!iterator.hasNext()) {
            return Iterators.emptyIterator();
        }
        Long scn = this.connection.getSCN();
        final long timestamp = scn == null ? Long.MAX_VALUE : scn;
        return new Iterator<Pair<byte[], List<Mutation>>>(){
            private Map.Entry<TableRef, Map<ImmutableBytesPtr, Map<PColumn, byte[]>>> current;
            private Iterator<Pair<byte[], List<Mutation>>> innerIterator;
            {
                this.current = (Map.Entry)iterator.next();
                this.innerIterator = this.init();
            }

            private Iterator<Pair<byte[], List<Mutation>>> init() {
                return MutationState.this.addRowMutations(this.current.getKey(), this.current.getValue(), timestamp, includeMutableIndexes);
            }

            @Override
            public boolean hasNext() {
                return this.innerIterator.hasNext() || iterator.hasNext();
            }

            @Override
            public Pair<byte[], List<Mutation>> next() {
                if (!this.innerIterator.hasNext()) {
                    this.current = (Map.Entry)iterator.next();
                }
                return this.innerIterator.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private long[] validate() throws SQLException {
        int i = 0;
        Long scn = this.connection.getSCN();
        PName tenantId = this.connection.getTenantId();
        MetaDataClient client = new MetaDataClient(this.connection);
        long[] timeStamps = new long[this.mutations.size()];
        for (Map.Entry<TableRef, Map<ImmutableBytesPtr, Map<PColumn, byte[]>>> entry : this.mutations.entrySet()) {
            MetaDataProtocol.MetaDataMutationResult result;
            long timestamp;
            TableRef tableRef = entry.getKey();
            long serverTimeStamp = tableRef.getTimeStamp();
            PTable table = tableRef.getTable();
            if (!this.connection.getAutoCommit() && (timestamp = (result = client.updateCache(table.getSchemaName().getString(), table.getTableName().getString())).getMutationTime()) != -1L) {
                serverTimeStamp = timestamp;
                if (result.wasUpdated()) {
                    PColumn[] columns = new PColumn[table.getColumns().size()];
                    for (Map.Entry<ImmutableBytesPtr, Map<PColumn, byte[]>> rowEntry : entry.getValue().entrySet()) {
                        Map<PColumn, byte[]> valueEntry = rowEntry.getValue();
                        if (valueEntry == PRow.DELETE_MARKER) continue;
                        Iterator<PColumn> i$ = valueEntry.keySet().iterator();
                        while (i$.hasNext()) {
                            PColumn column;
                            columns[column.getPosition()] = column = i$.next();
                        }
                    }
                    table = this.connection.getMetaDataCache().getTable(new PTableKey(tenantId, table.getName().getString()));
                    for (PColumn column : columns) {
                        if (column == null) continue;
                        table.getColumnFamily(column.getFamilyName().getString()).getColumn(column.getName().getString());
                    }
                }
            }
            timeStamps[i++] = scn == null ? (serverTimeStamp == -1L ? Long.MAX_VALUE : serverTimeStamp) : scn;
        }
        return timeStamps;
    }

    private static void logMutationSize(HTableInterface htable, List<Mutation> mutations) {
        long byteSize = 0L;
        int keyValueCount = 0;
        for (Mutation mutation : mutations) {
            if (mutation.getFamilyCellMap() == null) continue;
            for (Map.Entry entry : mutation.getFamilyCellMap().entrySet()) {
                if (entry.getValue() == null) continue;
                for (Cell kv : (List)entry.getValue()) {
                    byteSize += (long)CellUtil.estimatedSizeOf(kv);
                    ++keyValueCount;
                }
            }
        }
        logger.debug("Sending " + mutations.size() + " mutations for " + Bytes.toString(htable.getTableName()) + " with " + keyValueCount + " key values of total size " + byteSize + " bytes");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void commit() throws SQLException {
        int i = 0;
        byte[] tenantId = this.connection.getTenantId() == null ? null : this.connection.getTenantId().getBytes();
        long[] serverTimeStamps = this.validate();
        Iterator<Map.Entry<TableRef, Map<ImmutableBytesPtr, Map<PColumn, byte[]>>>> iterator = this.mutations.entrySet().iterator();
        ArrayList<Map.Entry<TableRef, Map<ImmutableBytesPtr, Map<PColumn, byte[]>>>> committedList = Lists.newArrayListWithCapacity(this.mutations.size());
        block48: while (true) {
            if (!iterator.hasNext()) {
                assert (this.numRows == 0);
                assert (this.mutations.isEmpty());
                return;
            }
            Map.Entry<TableRef, Map<ImmutableBytesPtr, Map<PColumn, byte[]>>> entry = iterator.next();
            Map<ImmutableBytesPtr, Map<PColumn, byte[]>> valuesMap = entry.getValue();
            TableRef tableRef = entry.getKey();
            PTable table = tableRef.getTable();
            table.getIndexMaintainers(this.tempPtr);
            boolean hasIndexMaintainers = this.tempPtr.getLength() > 0;
            boolean isDataTable = true;
            long serverTimestamp = serverTimeStamps[i++];
            Iterator<Pair<byte[], List<Mutation>>> mutationsIterator = this.addRowMutations(tableRef, valuesMap, serverTimestamp, false);
            while (true) {
                if (!mutationsIterator.hasNext()) {
                    this.numRows -= entry.getValue().size();
                    iterator.remove();
                    continue block48;
                }
                Pair<byte[], List<Mutation>> pair = mutationsIterator.next();
                byte[] htableName = pair.getFirst();
                List<Mutation> mutations = pair.getSecond();
                int retryCount = 0;
                boolean shouldRetry = false;
                do {
                    ServerCacheClient.ServerCache cache = null;
                    if (hasIndexMaintainers && isDataTable) {
                        byte[] uuidValue;
                        byte[] attribValue = null;
                        if (IndexMetaDataCacheClient.useIndexMetadataCache(this.connection, mutations, this.tempPtr.getLength())) {
                            IndexMetaDataCacheClient client = new IndexMetaDataCacheClient(this.connection, tableRef);
                            cache = client.addIndexMetadataCache(mutations, (ImmutableBytesWritable)this.tempPtr);
                            uuidValue = cache.getId();
                            shouldRetry = true;
                        } else {
                            attribValue = ByteUtil.copyKeyBytesIfNecessary(this.tempPtr);
                            uuidValue = ServerCacheClient.generateId();
                        }
                        for (Mutation mutation : mutations) {
                            if (tenantId != null) {
                                mutation.setAttribute("TenantId", tenantId);
                            }
                            mutation.setAttribute("IdxUUID", uuidValue);
                            if (attribValue == null) continue;
                            mutation.setAttribute("IdxMD", attribValue);
                        }
                    }
                    SQLException sqlE = null;
                    HTableInterface hTable = this.connection.getQueryServices().getTable(htableName);
                    try {
                        if (logger.isDebugEnabled()) {
                            MutationState.logMutationSize(hTable, mutations);
                        }
                        long startTime = System.currentTimeMillis();
                        hTable.batch(mutations);
                        shouldRetry = false;
                        if (logger.isDebugEnabled()) {
                            logger.debug("Total time for batch call of  " + mutations.size() + " mutations into " + table.getName().getString() + ": " + (System.currentTimeMillis() - startTime) + " ms");
                        }
                        committedList.add(entry);
                    }
                    catch (Exception e2) {
                        SQLException e2;
                        SQLException inferredE = ServerUtil.parseServerExceptionOrNull(e2);
                        if (inferredE != null) {
                            if (shouldRetry && retryCount == 0 && inferredE.getErrorCode() == SQLExceptionCode.INDEX_METADATA_NOT_FOUND.getErrorCode()) {
                                logger.warn("Swallowing exception and retrying after clearing meta cache on connection. " + inferredE);
                                this.connection.getQueryServices().clearTableRegionCache(htableName);
                            }
                            e2 = inferredE;
                        }
                        sqlE = new CommitException(e2, this, new MutationState(committedList, this.sizeOffset, this.maxSize, this.connection));
                    }
                    finally {
                        try {
                            hTable.close();
                        }
                        catch (IOException e) {
                            if (sqlE != null) {
                                sqlE.setNextException(ServerUtil.parseServerException(e));
                            }
                            sqlE = ServerUtil.parseServerException(e);
                        }
                        finally {
                            try {
                                if (cache != null) {
                                    cache.close();
                                }
                            }
                            finally {
                                if (sqlE == null) continue;
                                throw sqlE;
                            }
                        }
                    }
                } while (shouldRetry && retryCount++ < 1);
                isDataTable = false;
            }
            break;
        }
    }

    public void rollback(PhoenixConnection connection) throws SQLException {
        this.mutations.clear();
        this.numRows = 0;
    }

    @Override
    public void close() throws SQLException {
    }
}

