/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.execute;

import java.sql.SQLException;
import java.util.List;
import org.apache.phoenix.compile.GroupByCompiler;
import org.apache.phoenix.compile.OrderByCompiler;
import org.apache.phoenix.compile.RowProjector;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.coprocessor.ScanRegionObserver;
import org.apache.phoenix.execute.BasicQueryPlan;
import org.apache.phoenix.iterate.ConcatResultIterator;
import org.apache.phoenix.iterate.LimitingResultIterator;
import org.apache.phoenix.iterate.MergeSortRowKeyResultIterator;
import org.apache.phoenix.iterate.MergeSortTopNResultIterator;
import org.apache.phoenix.iterate.ParallelIterators;
import org.apache.phoenix.iterate.ResultIterator;
import org.apache.phoenix.iterate.SequenceResultIterator;
import org.apache.phoenix.iterate.SpoolingResultIterator;
import org.apache.phoenix.parse.FilterableStatement;
import org.apache.phoenix.query.KeyRange;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.util.ScanUtil;

public class ScanPlan
extends BasicQueryPlan {
    private List<KeyRange> splits;

    public ScanPlan(StatementContext context, FilterableStatement statement, TableRef table, RowProjector projector, Integer limit, OrderByCompiler.OrderBy orderBy, ParallelIterators.ParallelIteratorFactory parallelIteratorFactory) {
        super(context, statement, table, projector, context.getBindManager().getParameterMetaData(), limit, orderBy, null, parallelIteratorFactory != null ? parallelIteratorFactory : new SpoolingResultIterator.SpoolingResultIteratorFactory(context.getConnection().getQueryServices()));
        if (!orderBy.getOrderByExpressions().isEmpty()) {
            int thresholdBytes = context.getConnection().getQueryServices().getProps().getInt("phoenix.query.spoolThresholdBytes", 0x1400000);
            ScanRegionObserver.serializeIntoScan(context.getScan(), thresholdBytes, limit == null ? -1 : limit, orderBy.getOrderByExpressions(), projector.getEstimatedRowByteSize());
        }
    }

    @Override
    public List<KeyRange> getSplits() {
        return this.splits;
    }

    @Override
    protected ResultIterator newIterator() throws SQLException {
        ResultIterator scanner;
        TableRef tableRef;
        PTable table;
        this.context.getScan().setAttribute("_NonAggregateQuery", QueryConstants.TRUE);
        if (OrderByCompiler.OrderBy.REV_ROW_KEY_ORDER_BY.equals(this.orderBy)) {
            ScanUtil.setReversed(this.context.getScan());
        }
        boolean isSalted = (table = (tableRef = this.getTableRef()).getTable()).getBucketNum() != null;
        boolean isOrdered = !this.orderBy.getOrderByExpressions().isEmpty();
        ParallelIterators iterators = new ParallelIterators(this.context, tableRef, this.statement, this.projection, GroupByCompiler.GroupBy.EMPTY_GROUP_BY, isOrdered ? null : this.limit, this.parallelIteratorFactory);
        this.splits = iterators.getSplits();
        if (isOrdered) {
            scanner = new MergeSortTopNResultIterator(iterators, this.limit, this.orderBy.getOrderByExpressions());
        } else {
            scanner = isSalted && (this.context.getConnection().getQueryServices().getProps().getBoolean("phoenix.query.rowKeyOrderSaltedTable", true) || this.orderBy == OrderByCompiler.OrderBy.FWD_ROW_KEY_ORDER_BY || this.orderBy == OrderByCompiler.OrderBy.REV_ROW_KEY_ORDER_BY) ? new MergeSortRowKeyResultIterator(iterators, 1, this.orderBy == OrderByCompiler.OrderBy.REV_ROW_KEY_ORDER_BY) : new ConcatResultIterator(iterators);
            if (this.limit != null) {
                scanner = new LimitingResultIterator(scanner, this.limit);
            }
        }
        if (this.context.getSequenceManager().getSequenceCount() > 0) {
            scanner = new SequenceResultIterator(scanner, this.context.getSequenceManager());
        }
        return scanner;
    }
}

