/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression;

import java.util.BitSet;
import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.BaseCompoundExpression;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.schema.PDataType;
import org.apache.phoenix.schema.tuple.Tuple;

public abstract class AndOrExpression
extends BaseCompoundExpression {
    private BitSet partialEvalState;

    public AndOrExpression() {
    }

    public AndOrExpression(List<Expression> children) {
        super(children);
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + Boolean.valueOf(this.getStopValue()).hashCode();
    }

    @Override
    public PDataType getDataType() {
        return PDataType.BOOLEAN;
    }

    @Override
    public void reset() {
        if (this.partialEvalState == null) {
            this.partialEvalState = new BitSet(this.children.size());
        } else {
            this.partialEvalState.clear();
        }
        super.reset();
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        boolean isNull = false;
        boolean stopValue = this.getStopValue();
        for (int i = 0; i < this.children.size(); ++i) {
            Expression child = (Expression)this.children.get(i);
            if (this.partialEvalState != null && this.partialEvalState.get(i)) continue;
            if (child.evaluate(tuple, ptr)) {
                if (Boolean.valueOf(stopValue).equals(PDataType.BOOLEAN.toObject(ptr, child.getDataType()))) {
                    return true;
                }
                if (this.partialEvalState == null) continue;
                this.partialEvalState.set(i);
                continue;
            }
            isNull = true;
        }
        return !isNull;
    }

    protected abstract boolean getStopValue();
}

