/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression;

import java.util.List;
import org.apache.phoenix.expression.BaseCompoundExpression;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.schema.PDataType;

public abstract class ArithmeticExpression
extends BaseCompoundExpression {
    public ArithmeticExpression() {
    }

    public ArithmeticExpression(List<Expression> children) {
        super(children);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder("(");
        for (int i = 0; i < this.children.size() - 1; ++i) {
            buf.append(this.children.get(i) + this.getOperatorString());
        }
        buf.append(this.children.get(this.children.size() - 1));
        buf.append(')');
        return buf.toString();
    }

    protected Integer getScale(Expression e) {
        Integer scale = e.getScale();
        if (scale != null) {
            return scale;
        }
        PDataType dataType = e.getDataType();
        if (dataType != null && (scale = dataType.getScale(null)) != null) {
            return scale;
        }
        return null;
    }

    protected int getPrecision(Expression e) {
        Integer precision = e.getMaxLength();
        if (precision != null) {
            return precision;
        }
        PDataType dataType = e.getDataType();
        if (dataType != null && (precision = dataType.getMaxLength(null)) != null) {
            return precision;
        }
        return 38;
    }

    protected abstract String getOperatorString();
}

