/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.phoenix.expression.BaseCompoundExpression;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.schema.PArrayDataType;
import org.apache.phoenix.schema.PDataType;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.util.TrustedByteArrayOutputStream;

public class ArrayConstructorExpression
extends BaseCompoundExpression {
    private PDataType baseType;
    private int position = -1;
    private Object[] elements;
    private TrustedByteArrayOutputStream byteStream = null;
    private DataOutputStream oStream = null;
    private int estimatedSize = 0;
    private int[] offsetPos;

    public ArrayConstructorExpression(List<Expression> children, PDataType baseType) {
        super(children);
        this.init(baseType);
        this.estimatedSize = PArrayDataType.estimateSize(this.children.size(), this.baseType);
        if (!this.baseType.isFixedWidth()) {
            this.offsetPos = new int[children.size()];
            this.byteStream = new TrustedByteArrayOutputStream(this.estimatedSize);
        } else {
            this.byteStream = new TrustedByteArrayOutputStream(this.estimatedSize);
        }
    }

    private void init(PDataType baseType) {
        this.baseType = baseType;
        this.elements = new Object[this.getChildren().size()];
    }

    @Override
    public PDataType getDataType() {
        return PDataType.fromTypeId(this.baseType.getSqlType() + 3000);
    }

    @Override
    public void reset() {
        super.reset();
        this.position = 0;
        Arrays.fill(this.elements, null);
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        boolean bl;
        try {
            int i;
            int noOfElements = this.children.size();
            int nNulls = 0;
            this.oStream = new DataOutputStream(this.byteStream);
            int n = i = this.position >= 0 ? this.position : 0;
            while (i < this.elements.length) {
                Expression child = (Expression)this.children.get(i);
                if (!child.evaluate(tuple, ptr)) {
                    if (tuple != null && !tuple.isImmutable()) {
                        if (this.position >= 0) {
                            this.position = i;
                        }
                        boolean bl2 = false;
                        return bl2;
                    }
                } else if (!this.baseType.isFixedWidth()) {
                    if (ptr.getLength() == 0) {
                        this.offsetPos[i] = this.byteStream.size();
                        ++nNulls;
                    } else {
                        PArrayDataType.serializeNulls(this.oStream, nNulls);
                        this.offsetPos[i] = this.byteStream.size();
                        this.oStream.write(ptr.get(), ptr.getOffset(), ptr.getLength());
                        this.oStream.write(0);
                    }
                } else {
                    this.oStream.write(ptr.get(), ptr.getOffset(), ptr.getLength());
                }
                ++i;
            }
            if (this.position >= 0) {
                this.position = this.elements.length;
            }
            if (!this.baseType.isFixedWidth()) {
                PArrayDataType.writeEndSeperatorForVarLengthArray(this.oStream);
                noOfElements = PArrayDataType.serailizeOffsetArrayIntoStream(this.oStream, this.byteStream, noOfElements, this.offsetPos[this.offsetPos.length - 1], this.offsetPos);
                PArrayDataType.serializeHeaderInfoIntoStream(this.oStream, noOfElements);
            }
            ptr.set(this.byteStream.getBuffer(), 0, this.byteStream.size());
            bl = true;
        }
        catch (IOException e) {
            throw new RuntimeException("Exception while serializing the byte array");
        }
        finally {
            try {
                this.byteStream.close();
                this.oStream.close();
            }
            catch (IOException e) {}
        }
        return bl;
    }

    @Override
    public void readFields(DataInput input) throws IOException {
        super.readFields(input);
        int baseTypeOrdinal = WritableUtils.readVInt(input);
        this.init(PDataType.values()[baseTypeOrdinal]);
    }

    @Override
    public void write(DataOutput output) throws IOException {
        super.write(output);
        WritableUtils.writeVInt(output, this.baseType.ordinal());
    }

    @Override
    public boolean requiresFinalEvaluation() {
        return true;
    }
}

