/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression;

import com.google.common.collect.ImmutableList;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.io.WritableUtils;
import org.apache.phoenix.expression.BaseExpression;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.ExpressionType;
import org.apache.phoenix.expression.visitor.ExpressionVisitor;

public abstract class BaseCompoundExpression
extends BaseExpression {
    protected List<Expression> children;
    private boolean isNullable;
    private boolean isStateless;
    private boolean isDeterministic;
    private boolean requiresFinalEvaluation;

    public BaseCompoundExpression() {
    }

    public BaseCompoundExpression(List<Expression> children) {
        this.init(children);
    }

    private void init(List<Expression> children) {
        this.children = ImmutableList.copyOf(children);
        boolean isStateless = true;
        boolean isDeterministic = true;
        boolean isNullable = false;
        boolean requiresFinalEvaluation = false;
        for (int i = 0; i < children.size(); ++i) {
            Expression child = children.get(i);
            isNullable |= child.isNullable();
            isStateless &= child.isStateless();
            isDeterministic &= child.isDeterministic();
            requiresFinalEvaluation |= child.requiresFinalEvaluation();
        }
        this.isStateless = isStateless;
        this.isDeterministic = isDeterministic;
        this.isNullable = isNullable;
        this.requiresFinalEvaluation = requiresFinalEvaluation;
    }

    @Override
    public List<Expression> getChildren() {
        return this.children;
    }

    @Override
    public boolean isDeterministic() {
        return this.isDeterministic;
    }

    @Override
    public boolean isStateless() {
        return this.isStateless;
    }

    @Override
    public boolean isNullable() {
        return this.isNullable;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + ((Object)this.children).hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BaseCompoundExpression other = (BaseCompoundExpression)obj;
        return ((Object)this.children).equals(other.children);
    }

    @Override
    public void readFields(DataInput input) throws IOException {
        int len = WritableUtils.readVInt(input);
        ArrayList<Expression> children = new ArrayList<Expression>(len);
        for (int i = 0; i < len; ++i) {
            Expression child = ExpressionType.values()[WritableUtils.readVInt(input)].newInstance();
            child.readFields(input);
            children.add(child);
        }
        this.init(children);
    }

    @Override
    public void write(DataOutput output) throws IOException {
        WritableUtils.writeVInt(output, this.children.size());
        for (int i = 0; i < this.children.size(); ++i) {
            Expression child = this.children.get(i);
            WritableUtils.writeVInt(output, ExpressionType.valueOf(child).ordinal());
            child.write(output);
        }
    }

    @Override
    public void reset() {
        for (int i = 0; i < this.children.size(); ++i) {
            this.children.get(i).reset();
        }
    }

    @Override
    public <T> T accept(ExpressionVisitor<T> visitor) {
        List<T> l = this.acceptChildren(visitor, visitor.visitEnter(this));
        T t = visitor.visitLeave(this, l);
        if (t == null) {
            t = visitor.defaultReturn(this, l);
        }
        return t;
    }

    public String toString() {
        return this.getClass().getName() + " [children=" + this.children + "]";
    }

    @Override
    public boolean requiresFinalEvaluation() {
        return this.requiresFinalEvaluation;
    }
}

