/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression;

import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.phoenix.expression.BaseSingleExpression;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.visitor.ExpressionVisitor;
import org.apache.phoenix.schema.PDataType;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.tuple.Tuple;

public class CoerceExpression
extends BaseSingleExpression {
    private PDataType toType;
    private SortOrder toSortOrder;
    private Integer maxLength;

    public CoerceExpression() {
    }

    public static Expression create(Expression expression, PDataType toType) throws SQLException {
        if (toType == expression.getDataType()) {
            return expression;
        }
        return new CoerceExpression(expression, toType);
    }

    public static Expression create(Expression expression, PDataType toType, SortOrder toSortOrder, Integer maxLength) throws SQLException {
        if (toType == expression.getDataType() && toSortOrder == expression.getSortOrder()) {
            return expression;
        }
        return new CoerceExpression(expression, toType, toSortOrder, maxLength);
    }

    CoerceExpression(Expression expression, PDataType toType) {
        this(expression, toType, SortOrder.getDefault(), null);
    }

    CoerceExpression(Expression expression, PDataType toType, SortOrder toSortOrder, Integer maxLength) {
        super(expression);
        Preconditions.checkNotNull(toSortOrder);
        this.toType = toType;
        this.toSortOrder = toSortOrder;
        this.maxLength = maxLength;
    }

    @Override
    public Integer getMaxLength() {
        return this.maxLength;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.maxLength == null ? 0 : this.maxLength.hashCode());
        result = 31 * result + (this.toSortOrder == null ? 0 : this.toSortOrder.hashCode());
        result = 31 * result + (this.toType == null ? 0 : this.toType.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CoerceExpression other = (CoerceExpression)obj;
        if (this.maxLength == null ? other.maxLength != null : !this.maxLength.equals(other.maxLength)) {
            return false;
        }
        if (this.toSortOrder != other.toSortOrder) {
            return false;
        }
        return this.toType == other.toType;
    }

    @Override
    public void readFields(DataInput input) throws IOException {
        super.readFields(input);
        this.toType = PDataType.values()[WritableUtils.readVInt(input)];
        this.toSortOrder = SortOrder.fromSystemValue(WritableUtils.readVInt(input));
        int byteSize = WritableUtils.readVInt(input);
        this.maxLength = byteSize == -1 ? null : Integer.valueOf(byteSize);
    }

    @Override
    public void write(DataOutput output) throws IOException {
        super.write(output);
        WritableUtils.writeVInt(output, this.toType.ordinal());
        WritableUtils.writeVInt(output, this.toSortOrder.getSystemValue());
        WritableUtils.writeVInt(output, this.maxLength == null ? -1 : this.maxLength);
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        if (this.getChild().evaluate(tuple, ptr)) {
            this.getDataType().coerceBytes(ptr, this.getChild().getDataType(), this.getChild().getSortOrder(), this.getSortOrder(), this.getChild().getMaxLength());
            return true;
        }
        return false;
    }

    @Override
    public PDataType getDataType() {
        return this.toType;
    }

    @Override
    public SortOrder getSortOrder() {
        return this.toSortOrder;
    }

    @Override
    public <T> T accept(ExpressionVisitor<T> visitor) {
        List<T> l = this.acceptChildren(visitor, visitor.visitEnter(this));
        T t = visitor.visitLeave(this, l);
        if (t == null) {
            t = visitor.defaultReturn(this, l);
        }
        return t;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("TO_" + this.toType.toString() + "(");
        for (int i = 0; i < this.children.size() - 1; ++i) {
            buf.append(this.children.get(i) + ", ");
        }
        buf.append(this.children.get(this.children.size() - 1) + ")");
        return buf.toString();
    }
}

