/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.WritableUtils;
import org.apache.phoenix.expression.BaseTerminalExpression;
import org.apache.phoenix.schema.PDataType;
import org.apache.phoenix.schema.PDatum;
import org.apache.phoenix.schema.SortOrder;

public abstract class ColumnExpression
extends BaseTerminalExpression {
    protected PDataType type;
    private boolean isNullable;
    private Integer maxLength;
    private Integer scale;
    private SortOrder sortOrder;

    public ColumnExpression() {
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.isNullable() ? 1231 : 1237);
        PDataType type = this.getDataType();
        result = 31 * result + (type == null ? 0 : type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ColumnExpression other = (ColumnExpression)obj;
        if (this.isNullable() != other.isNullable()) {
            return false;
        }
        return this.getDataType() == other.getDataType();
    }

    public ColumnExpression(PDatum datum) {
        this.type = datum.getDataType();
        this.isNullable = datum.isNullable();
        this.maxLength = datum.getMaxLength();
        this.scale = datum.getScale();
        this.sortOrder = datum.getSortOrder();
    }

    @Override
    public boolean isNullable() {
        return this.isNullable;
    }

    @Override
    public PDataType getDataType() {
        return this.type;
    }

    @Override
    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    @Override
    public Integer getMaxLength() {
        return this.maxLength;
    }

    @Override
    public Integer getScale() {
        return this.scale;
    }

    @Override
    public void readFields(DataInput input) throws IOException {
        int typeAndFlag = WritableUtils.readVInt(input);
        boolean bl = this.isNullable = (typeAndFlag & 1) != 0;
        if ((typeAndFlag & 2) != 0) {
            this.scale = WritableUtils.readVInt(input);
        }
        if ((typeAndFlag & 4) != 0) {
            this.maxLength = WritableUtils.readVInt(input);
        }
        this.type = PDataType.values()[typeAndFlag >>> 3];
        this.sortOrder = SortOrder.fromSystemValue(WritableUtils.readVInt(input));
    }

    @Override
    public void write(DataOutput output) throws IOException {
        int typeAndFlag = (this.isNullable ? 1 : 0) | (this.scale != null ? 1 : 0) << 1 | (this.maxLength != null ? 1 : 0) << 2 | this.type.ordinal() << 3;
        WritableUtils.writeVInt(output, typeAndFlag);
        if (this.scale != null) {
            WritableUtils.writeVInt(output, this.scale);
        }
        if (this.maxLength != null) {
            WritableUtils.writeVInt(output, this.maxLength);
        }
        WritableUtils.writeVInt(output, this.sortOrder.getSystemValue());
    }
}

