/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression;

import com.google.common.collect.Lists;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.phoenix.expression.AndExpression;
import org.apache.phoenix.expression.BaseCompoundExpression;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.IsNullExpression;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.expression.NotExpression;
import org.apache.phoenix.expression.RowValueConstructorExpression;
import org.apache.phoenix.expression.visitor.ExpressionVisitor;
import org.apache.phoenix.schema.PDataType;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.TypeMismatchException;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.StringUtil;

public class ComparisonExpression
extends BaseCompoundExpression {
    private CompareFilter.CompareOp op;
    private static final String[] CompareOpString = new String[CompareFilter.CompareOp.values().length];

    private static void addEqualityExpression(Expression lhs, Expression rhs, List<Expression> andNodes, ImmutableBytesWritable ptr) throws SQLException {
        boolean isRHSNull;
        boolean isLHSNull = lhs.isStateless() && (!lhs.evaluate(null, ptr) || ptr.getLength() == 0);
        boolean bl = isRHSNull = rhs.isStateless() && (!rhs.evaluate(null, ptr) || ptr.getLength() == 0);
        if (isLHSNull && isRHSNull) {
            andNodes.add(LiteralExpression.newConstant((Object)false, PDataType.BOOLEAN));
        } else if (isLHSNull) {
            andNodes.add(IsNullExpression.create(rhs, false, ptr));
        } else if (isRHSNull) {
            andNodes.add(IsNullExpression.create(lhs, false, ptr));
        } else {
            andNodes.add(ComparisonExpression.create(CompareFilter.CompareOp.EQUAL, Arrays.asList(lhs, rhs), ptr));
        }
    }

    private static void rewriteRVCAsEqualityExpression(Expression lhs, Expression rhs, List<Expression> andNodes, ImmutableBytesWritable ptr) throws SQLException {
        block6: {
            block7: {
                block5: {
                    int i;
                    if (!(lhs instanceof RowValueConstructorExpression) || !(rhs instanceof RowValueConstructorExpression)) break block5;
                    for (i = 0; i < Math.min(lhs.getChildren().size(), rhs.getChildren().size()); ++i) {
                        ComparisonExpression.addEqualityExpression(lhs.getChildren().get(i), rhs.getChildren().get(i), andNodes, ptr);
                    }
                    while (i < lhs.getChildren().size()) {
                        ComparisonExpression.addEqualityExpression(lhs.getChildren().get(i), LiteralExpression.newConstant(null, lhs.getChildren().get(i).getDataType()), andNodes, ptr);
                        ++i;
                    }
                    while (i < rhs.getChildren().size()) {
                        ComparisonExpression.addEqualityExpression(LiteralExpression.newConstant(null, rhs.getChildren().get(i).getDataType()), rhs.getChildren().get(i), andNodes, ptr);
                        ++i;
                    }
                    break block6;
                }
                if (!(lhs instanceof RowValueConstructorExpression)) break block7;
                ComparisonExpression.addEqualityExpression(lhs.getChildren().get(0), rhs, andNodes, ptr);
                for (int i = 1; i < lhs.getChildren().size(); ++i) {
                    ComparisonExpression.addEqualityExpression(lhs.getChildren().get(i), LiteralExpression.newConstant(null, lhs.getChildren().get(i).getDataType()), andNodes, ptr);
                }
                break block6;
            }
            if (!(rhs instanceof RowValueConstructorExpression)) break block6;
            ComparisonExpression.addEqualityExpression(lhs, rhs.getChildren().get(0), andNodes, ptr);
            for (int i = 1; i < rhs.getChildren().size(); ++i) {
                ComparisonExpression.addEqualityExpression(LiteralExpression.newConstant(null, rhs.getChildren().get(i).getDataType()), rhs.getChildren().get(i), andNodes, ptr);
            }
        }
    }

    public static Expression create(CompareFilter.CompareOp op, List<Expression> children, ImmutableBytesWritable ptr) throws SQLException {
        Expression lhsExpr = children.get(0);
        Expression rhsExpr = children.get(1);
        PDataType lhsExprDataType = lhsExpr.getDataType();
        PDataType rhsExprDataType = rhsExpr.getDataType();
        if (lhsExpr instanceof RowValueConstructorExpression || rhsExpr instanceof RowValueConstructorExpression) {
            if (op == CompareFilter.CompareOp.EQUAL || op == CompareFilter.CompareOp.NOT_EQUAL) {
                ArrayList<Expression> andNodes = Lists.newArrayListWithExpectedSize(Math.max(lhsExpr.getChildren().size(), rhsExpr.getChildren().size()));
                ComparisonExpression.rewriteRVCAsEqualityExpression(lhsExpr, rhsExpr, andNodes, ptr);
                Expression expr = AndExpression.create(andNodes);
                if (op == CompareFilter.CompareOp.NOT_EQUAL) {
                    expr = NotExpression.create(expr, ptr);
                }
                return expr;
            }
            rhsExpr = RowValueConstructorExpression.coerce(lhsExpr, rhsExpr, op);
            if (!(lhsExpr instanceof RowValueConstructorExpression)) {
                lhsExpr = new RowValueConstructorExpression(Collections.singletonList(lhsExpr), lhsExpr.isStateless());
            }
            children = Arrays.asList(lhsExpr, rhsExpr);
        } else if (lhsExprDataType != null && rhsExprDataType != null && !lhsExprDataType.isComparableTo(rhsExprDataType)) {
            throw TypeMismatchException.newException(lhsExprDataType, rhsExprDataType, ComparisonExpression.toString(op, children));
        }
        boolean isDeterministic = lhsExpr.isDeterministic() || rhsExpr.isDeterministic();
        Object lhsValue = null;
        if (lhsExpr instanceof LiteralExpression && (lhsValue = ((LiteralExpression)lhsExpr).getValue()) == null) {
            return LiteralExpression.newConstant((Object)false, PDataType.BOOLEAN, lhsExpr.isDeterministic());
        }
        Object rhsValue = null;
        if (rhsExpr instanceof LiteralExpression && (rhsValue = ((LiteralExpression)rhsExpr).getValue()) == null) {
            return LiteralExpression.newConstant((Object)false, PDataType.BOOLEAN, rhsExpr.isDeterministic());
        }
        if (lhsValue != null && rhsValue != null) {
            return LiteralExpression.newConstant((Object)ByteUtil.compare(op, lhsExprDataType.compareTo(lhsValue, rhsValue, rhsExprDataType)), isDeterministic);
        }
        if (rhsValue != null) {
            if (rhsExprDataType != lhsExprDataType || rhsExpr.getSortOrder() != lhsExpr.getSortOrder() || rhsExprDataType.isFixedWidth() && rhsExpr.getMaxLength() != null && lhsExprDataType.isFixedWidth() && lhsExpr.getMaxLength() != null && rhsExpr.getMaxLength() < lhsExpr.getMaxLength()) {
                if (rhsExprDataType.isCoercibleTo(lhsExprDataType, rhsValue)) {
                    children = Arrays.asList(children.get(0), LiteralExpression.newConstant(rhsValue, lhsExprDataType, lhsExpr.getMaxLength(), null, lhsExpr.getSortOrder(), isDeterministic));
                } else {
                    if (op == CompareFilter.CompareOp.EQUAL) {
                        return LiteralExpression.newConstant((Object)false, PDataType.BOOLEAN, true);
                    }
                    if (op == CompareFilter.CompareOp.NOT_EQUAL) {
                        return LiteralExpression.newConstant((Object)true, PDataType.BOOLEAN, true);
                    }
                    switch (rhsExprDataType) {
                        case DECIMAL: {
                            int increment = 0;
                            switch (op) {
                                case GREATER_OR_EQUAL: 
                                case LESS: {
                                    increment = 1;
                                }
                            }
                            BigDecimal bd = (BigDecimal)rhsValue;
                            rhsValue = bd.longValue() + (long)increment;
                            children = Arrays.asList(lhsExpr, LiteralExpression.newConstant(rhsValue, lhsExprDataType, lhsExpr.getSortOrder(), rhsExpr.isDeterministic()));
                            break;
                        }
                        case LONG: {
                            if (lhsExprDataType == PDataType.INTEGER || lhsExprDataType == PDataType.UNSIGNED_INT) {
                                switch (op) {
                                    case LESS: 
                                    case LESS_OR_EQUAL: {
                                        if ((Long)rhsValue > 0L) {
                                            return LiteralExpression.newConstant((Object)true, PDataType.BOOLEAN, isDeterministic);
                                        }
                                        return LiteralExpression.newConstant((Object)false, PDataType.BOOLEAN, isDeterministic);
                                    }
                                    case GREATER_OR_EQUAL: 
                                    case GREATER: {
                                        if ((Long)rhsValue > 0L) {
                                            return LiteralExpression.newConstant((Object)false, PDataType.BOOLEAN, isDeterministic);
                                        }
                                        return LiteralExpression.newConstant((Object)true, PDataType.BOOLEAN, isDeterministic);
                                    }
                                }
                            } else if (lhsExprDataType == PDataType.UNSIGNED_LONG) {
                                switch (op) {
                                    case LESS: 
                                    case LESS_OR_EQUAL: {
                                        return LiteralExpression.newConstant((Object)false, PDataType.BOOLEAN, isDeterministic);
                                    }
                                    case GREATER_OR_EQUAL: 
                                    case GREATER: {
                                        return LiteralExpression.newConstant((Object)true, PDataType.BOOLEAN, isDeterministic);
                                    }
                                }
                            }
                            children = Arrays.asList(lhsExpr, LiteralExpression.newConstant(rhsValue, rhsExprDataType, lhsExpr.getSortOrder(), isDeterministic));
                        }
                    }
                }
            }
            if (children.get(1).getMaxLength() != null && lhsExpr.getMaxLength() != null && lhsExpr.getMaxLength() < children.get(1).getMaxLength()) {
                switch (op) {
                    case EQUAL: {
                        return LiteralExpression.newConstant((Object)false, PDataType.BOOLEAN, isDeterministic);
                    }
                    case NOT_EQUAL: {
                        return LiteralExpression.newConstant((Object)true, PDataType.BOOLEAN, isDeterministic);
                    }
                }
            }
        }
        return new ComparisonExpression(op, children);
    }

    public ComparisonExpression() {
    }

    public ComparisonExpression(CompareFilter.CompareOp op, List<Expression> children) {
        super(children);
        if (op == null) {
            throw new NullPointerException();
        }
        this.op = op;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.op.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ComparisonExpression other = (ComparisonExpression)obj;
        return this.op == other.op;
    }

    @Override
    public PDataType getDataType() {
        return PDataType.BOOLEAN;
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        int comparisonResult;
        if (!((Expression)this.children.get(0)).evaluate(tuple, ptr)) {
            return false;
        }
        if (ptr.getLength() == 0) {
            return true;
        }
        byte[] lhsBytes = ptr.get();
        int lhsOffset = ptr.getOffset();
        int lhsLength = ptr.getLength();
        PDataType lhsDataType = ((Expression)this.children.get(0)).getDataType();
        SortOrder lhsSortOrder = ((Expression)this.children.get(0)).getSortOrder();
        if (!((Expression)this.children.get(1)).evaluate(tuple, ptr)) {
            return false;
        }
        if (ptr.getLength() == 0) {
            return true;
        }
        byte[] rhsBytes = ptr.get();
        int rhsOffset = ptr.getOffset();
        int rhsLength = ptr.getLength();
        PDataType rhsDataType = ((Expression)this.children.get(1)).getDataType();
        SortOrder rhsSortOrder = ((Expression)this.children.get(1)).getSortOrder();
        if (rhsDataType == PDataType.CHAR) {
            rhsLength = StringUtil.getUnpaddedCharLength(rhsBytes, rhsOffset, rhsLength, rhsSortOrder);
        }
        if (lhsDataType == PDataType.CHAR) {
            lhsLength = StringUtil.getUnpaddedCharLength(lhsBytes, lhsOffset, lhsLength, lhsSortOrder);
        }
        ptr.set(ByteUtil.compare(this.op, comparisonResult = lhsDataType.compareTo(lhsBytes, lhsOffset, lhsLength, lhsSortOrder, rhsBytes, rhsOffset, rhsLength, rhsSortOrder, rhsDataType)) ? PDataType.TRUE_BYTES : PDataType.FALSE_BYTES);
        return true;
    }

    @Override
    public void readFields(DataInput input) throws IOException {
        this.op = CompareFilter.CompareOp.values()[WritableUtils.readVInt(input)];
        super.readFields(input);
    }

    @Override
    public void write(DataOutput output) throws IOException {
        WritableUtils.writeVInt(output, this.op.ordinal());
        super.write(output);
    }

    @Override
    public final <T> T accept(ExpressionVisitor<T> visitor) {
        List<T> l = this.acceptChildren(visitor, visitor.visitEnter(this));
        T t = visitor.visitLeave(this, l);
        if (t == null) {
            t = visitor.defaultReturn(this, l);
        }
        return t;
    }

    public CompareFilter.CompareOp getFilterOp() {
        return this.op;
    }

    public static String toString(CompareFilter.CompareOp op, List<Expression> children) {
        return children.get(0) + CompareOpString[op.ordinal()] + children.get(1);
    }

    @Override
    public String toString() {
        return ComparisonExpression.toString(this.getFilterOp(), this.children);
    }

    static {
        ComparisonExpression.CompareOpString[CompareFilter.CompareOp.EQUAL.ordinal()] = " = ";
        ComparisonExpression.CompareOpString[CompareFilter.CompareOp.NOT_EQUAL.ordinal()] = " != ";
        ComparisonExpression.CompareOpString[CompareFilter.CompareOp.GREATER.ordinal()] = " > ";
        ComparisonExpression.CompareOpString[CompareFilter.CompareOp.LESS.ordinal()] = " < ";
        ComparisonExpression.CompareOpString[CompareFilter.CompareOp.GREATER_OR_EQUAL.ordinal()] = " >= ";
        ComparisonExpression.CompareOpString[CompareFilter.CompareOp.LESS_OR_EQUAL.ordinal()] = " <= ";
    }
}

