/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression;

import java.math.BigDecimal;
import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.SubtractExpression;
import org.apache.phoenix.schema.PDataType;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.tuple.Tuple;

public class DateSubtractExpression
extends SubtractExpression {
    public DateSubtractExpression() {
    }

    public DateSubtractExpression(List<Expression> children) {
        super(children);
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        long finalResult = 0L;
        for (int i = 0; i < this.children.size(); ++i) {
            long value;
            if (!((Expression)this.children.get(i)).evaluate(tuple, ptr) || ptr.getLength() == 0) {
                return false;
            }
            PDataType type = ((Expression)this.children.get(i)).getDataType();
            SortOrder sortOrder = ((Expression)this.children.get(i)).getSortOrder();
            if (type == PDataType.DECIMAL) {
                BigDecimal bd = (BigDecimal)PDataType.DECIMAL.toObject(ptr, sortOrder);
                value = bd.multiply(BD_MILLIS_IN_DAY).longValue();
            } else {
                value = type.isCoercibleTo(PDataType.LONG) ? type.getCodec().decodeLong(ptr, sortOrder) * 86400000L : (type.isCoercibleTo(PDataType.DOUBLE) ? (long)(type.getCodec().decodeDouble(ptr, sortOrder) * 8.64E7) : type.getCodec().decodeLong(ptr, sortOrder));
            }
            if (i == 0) {
                finalResult = value;
                continue;
            }
            finalResult -= value;
        }
        byte[] resultPtr = new byte[this.getDataType().getByteSize().intValue()];
        this.getDataType().getCodec().encodeLong(finalResult, resultPtr, 0);
        ptr.set(resultPtr);
        return true;
    }

    @Override
    public final PDataType getDataType() {
        return PDataType.DATE;
    }
}

