/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression;

import java.math.BigDecimal;
import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.exception.ValueTypeIncompatibleException;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.MultiplyExpression;
import org.apache.phoenix.schema.PDataType;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.util.NumberUtil;

public class DecimalMultiplyExpression
extends MultiplyExpression {
    public DecimalMultiplyExpression() {
    }

    public DecimalMultiplyExpression(List<Expression> children) {
        super(children);
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        BigDecimal result = null;
        for (int i = 0; i < this.children.size(); ++i) {
            Expression childExpr = (Expression)this.children.get(i);
            if (!childExpr.evaluate(tuple, ptr)) {
                return false;
            }
            if (ptr.getLength() == 0) {
                return true;
            }
            PDataType childType = ((Expression)this.children.get(i)).getDataType();
            SortOrder childSortOrder = ((Expression)this.children.get(i)).getSortOrder();
            BigDecimal bd = (BigDecimal)PDataType.DECIMAL.toObject(ptr, childType, childSortOrder);
            result = result == null ? bd : result.multiply(bd);
        }
        if (this.getMaxLength() != null || this.getScale() != null) {
            result = NumberUtil.setDecimalWidthAndScale(result, this.getMaxLength(), this.getScale());
        }
        if (result == null) {
            throw new ValueTypeIncompatibleException(PDataType.DECIMAL, this.getMaxLength(), this.getScale());
        }
        ptr.set(PDataType.DECIMAL.toBytes(result));
        return true;
    }

    @Override
    public PDataType getDataType() {
        return PDataType.DECIMAL;
    }
}

