/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression;

import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.SQLException;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.expression.BaseTerminalExpression;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.visitor.ExpressionVisitor;
import org.apache.phoenix.schema.IllegalDataException;
import org.apache.phoenix.schema.PDataType;
import org.apache.phoenix.schema.PhoenixArray;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.TypeMismatchException;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.StringUtil;

public class LiteralExpression
extends BaseTerminalExpression {
    public static final LiteralExpression NULL_EXPRESSION;
    private static final LiteralExpression ND_NULL_EXPRESSION;
    private static final LiteralExpression[] TYPED_NULL_EXPRESSIONS;
    private static final LiteralExpression FALSE_EXPRESSION;
    private static final LiteralExpression TRUE_EXPRESSION;
    private static final LiteralExpression ND_FALSE_EXPRESSION;
    private static final LiteralExpression ND_TRUE_EXPRESSION;
    private Object value;
    private PDataType type;
    private boolean isDeterministic;
    private byte[] byteValue;
    private Integer maxLength;
    private Integer scale;
    private SortOrder sortOrder;

    public static boolean isFalse(Expression child) {
        return child == FALSE_EXPRESSION || child == ND_FALSE_EXPRESSION;
    }

    public static boolean isTrue(Expression child) {
        return child == TRUE_EXPRESSION || child == ND_TRUE_EXPRESSION;
    }

    public static LiteralExpression newConstant(Object value) {
        return LiteralExpression.newConstant(value, true);
    }

    public static LiteralExpression newConstant(Object value, boolean isDeterministic) {
        String s;
        byte[] b;
        if (Boolean.FALSE.equals(value)) {
            return isDeterministic ? FALSE_EXPRESSION : ND_FALSE_EXPRESSION;
        }
        if (Boolean.TRUE.equals(value)) {
            return isDeterministic ? TRUE_EXPRESSION : ND_TRUE_EXPRESSION;
        }
        if (value == null) {
            return isDeterministic ? NULL_EXPRESSION : ND_NULL_EXPRESSION;
        }
        PDataType type = PDataType.fromLiteral(value);
        if (type.isNull(b = type.toBytes(value))) {
            return TYPED_NULL_EXPRESSIONS[type.ordinal() + (isDeterministic ? 0 : TYPED_NULL_EXPRESSIONS.length / 2)];
        }
        if (type == PDataType.VARCHAR && (s = (String)value).length() == b.length) {
            type = PDataType.CHAR;
        }
        return new LiteralExpression(value, type, b, isDeterministic);
    }

    public static LiteralExpression newConstant(Object value, PDataType type) throws SQLException {
        return LiteralExpression.newConstant(value, type, true);
    }

    public static LiteralExpression newConstant(Object value, PDataType type, boolean isDeterministic) throws SQLException {
        return LiteralExpression.newConstant(value, type, SortOrder.getDefault(), isDeterministic);
    }

    public static LiteralExpression newConstant(Object value, PDataType type, SortOrder sortOrder) throws SQLException {
        return LiteralExpression.newConstant(value, type, null, null, sortOrder, true);
    }

    public static LiteralExpression newConstant(Object value, PDataType type, SortOrder sortOrder, boolean isDeterministic) throws SQLException {
        return LiteralExpression.newConstant(value, type, null, null, sortOrder, isDeterministic);
    }

    public static LiteralExpression newConstant(Object value, PDataType type, Integer maxLength, Integer scale) throws SQLException {
        return LiteralExpression.newConstant(value, type, maxLength, scale, SortOrder.getDefault(), true);
    }

    public static LiteralExpression newConstant(Object value, PDataType type, Integer maxLength, Integer scale, boolean isDeterministic) throws SQLException {
        return LiteralExpression.newConstant(value, type, maxLength, scale, SortOrder.getDefault(), isDeterministic);
    }

    public static LiteralExpression newConstant(Object value, PDataType type, Integer maxLength, Integer scale, SortOrder sortOrder, boolean isDeterministic) throws SQLException {
        if (value == null) {
            if (type == null) {
                return NULL_EXPRESSION;
            }
            return TYPED_NULL_EXPRESSIONS[type.ordinal()];
        }
        if (Boolean.FALSE.equals(value)) {
            return isDeterministic ? FALSE_EXPRESSION : ND_FALSE_EXPRESSION;
        }
        if (Boolean.TRUE.equals(value)) {
            return isDeterministic ? TRUE_EXPRESSION : ND_TRUE_EXPRESSION;
        }
        PDataType actualType = PDataType.fromLiteral(value);
        if (!actualType.isCoercibleTo(type, value)) {
            throw TypeMismatchException.newException(type, actualType, value.toString());
        }
        value = type.toObject(value, actualType);
        try {
            byte[] b = type.toBytes(value, sortOrder);
            if (type == PDataType.VARCHAR || type == PDataType.CHAR) {
                if (type == PDataType.CHAR && maxLength != null && b.length < maxLength) {
                    b = StringUtil.padChar(b, maxLength);
                } else if (value != null) {
                    maxLength = ((String)value).length();
                }
            } else if (type.isArrayType()) {
                maxLength = ((PhoenixArray)value).getMaxLength();
            }
            if (b.length == 0) {
                return TYPED_NULL_EXPRESSIONS[type.ordinal()];
            }
            if (maxLength == null) {
                maxLength = type == null || !type.isFixedWidth() ? null : type.getMaxLength(value);
            }
            return new LiteralExpression(value, type, b, maxLength, scale, sortOrder, isDeterministic);
        }
        catch (IllegalDataException e) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.ILLEGAL_DATA).setRootCause(e).build().buildException();
        }
    }

    public LiteralExpression() {
    }

    private LiteralExpression(PDataType type, boolean isDeterministic) {
        this(null, type, ByteUtil.EMPTY_BYTE_ARRAY, isDeterministic);
    }

    private LiteralExpression(Object value, PDataType type, byte[] byteValue, boolean isDeterministic) {
        this(value, type, byteValue, type == null || !type.isFixedWidth() ? null : type.getMaxLength(value), null, SortOrder.getDefault(), isDeterministic);
    }

    private LiteralExpression(Object value, PDataType type, byte[] byteValue, Integer maxLength, Integer scale, SortOrder sortOrder, boolean isDeterministic) {
        Preconditions.checkNotNull(sortOrder);
        this.value = value;
        this.type = type;
        this.byteValue = byteValue;
        this.maxLength = maxLength;
        this.scale = scale != null ? scale : (type == null ? null : type.getScale(value));
        this.sortOrder = sortOrder;
        this.isDeterministic = isDeterministic;
    }

    @Override
    public boolean isDeterministic() {
        return this.isDeterministic;
    }

    public String toString() {
        return this.value == null ? "null" : this.type.toStringLiteral(this.byteValue, null);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LiteralExpression other = (LiteralExpression)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    @Override
    public void readFields(DataInput input) throws IOException {
        int encodedByteLengthAndBool = WritableUtils.readVInt(input);
        this.isDeterministic = encodedByteLengthAndBool > 0;
        int byteLength = Math.abs(encodedByteLengthAndBool) - 1;
        this.byteValue = new byte[byteLength];
        input.readFully(this.byteValue, 0, byteLength);
        this.sortOrder = SortOrder.fromSystemValue(WritableUtils.readVInt(input));
        int typeOrdinal = WritableUtils.readVInt(input);
        this.type = typeOrdinal < 0 ? null : PDataType.values()[typeOrdinal];
        this.value = this.byteValue.length == 0 ? null : this.type.toObject(this.byteValue, 0, this.byteValue.length, this.type, this.sortOrder);
    }

    @Override
    public void write(DataOutput output) throws IOException {
        WritableUtils.writeVInt(output, (this.byteValue.length + 1) * (this.isDeterministic ? 1 : -1));
        output.write(this.byteValue);
        WritableUtils.writeVInt(output, this.sortOrder.getSystemValue());
        WritableUtils.writeVInt(output, this.type == null ? -1 : this.type.ordinal());
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        ptr.set(this.byteValue);
        return true;
    }

    @Override
    public PDataType getDataType() {
        return this.type;
    }

    @Override
    public Integer getMaxLength() {
        return this.maxLength;
    }

    @Override
    public Integer getScale() {
        return this.scale;
    }

    @Override
    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    @Override
    public boolean isNullable() {
        return this.value == null;
    }

    public Object getValue() {
        return this.value;
    }

    public byte[] getBytes() {
        return this.byteValue;
    }

    @Override
    public final <T> T accept(ExpressionVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean isStateless() {
        return true;
    }

    static {
        int i;
        NULL_EXPRESSION = new LiteralExpression(null, false);
        ND_NULL_EXPRESSION = new LiteralExpression(null, true);
        TYPED_NULL_EXPRESSIONS = new LiteralExpression[PDataType.values().length * 2];
        for (i = 0; i < PDataType.values().length; ++i) {
            LiteralExpression.TYPED_NULL_EXPRESSIONS[i] = new LiteralExpression(PDataType.values()[i], true);
        }
        for (i = 0; i < PDataType.values().length; ++i) {
            LiteralExpression.TYPED_NULL_EXPRESSIONS[i + PDataType.values().length] = new LiteralExpression(PDataType.values()[i], false);
        }
        FALSE_EXPRESSION = new LiteralExpression(Boolean.FALSE, PDataType.BOOLEAN, PDataType.BOOLEAN.toBytes(Boolean.FALSE), true);
        TRUE_EXPRESSION = new LiteralExpression(Boolean.TRUE, PDataType.BOOLEAN, PDataType.BOOLEAN.toBytes(Boolean.TRUE), true);
        ND_FALSE_EXPRESSION = new LiteralExpression(Boolean.FALSE, PDataType.BOOLEAN, PDataType.BOOLEAN.toBytes(Boolean.FALSE), false);
        ND_TRUE_EXPRESSION = new LiteralExpression(Boolean.TRUE, PDataType.BOOLEAN, PDataType.BOOLEAN.toBytes(Boolean.TRUE), false);
    }
}

