/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression;

import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.DivideExpression;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.schema.PDataType;
import org.apache.phoenix.schema.tuple.Tuple;

public class LongDivideExpression
extends DivideExpression {
    public LongDivideExpression() {
    }

    public LongDivideExpression(List<Expression> children) {
        super(children);
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        long finalResult = 0L;
        for (int i = 0; i < this.children.size(); ++i) {
            Expression child = (Expression)this.children.get(i);
            if (!child.evaluate(tuple, ptr) || ptr.getLength() == 0) {
                return false;
            }
            long childvalue = child.getDataType().getCodec().decodeLong(ptr, child.getSortOrder());
            if (i == 0) {
                finalResult = childvalue;
                continue;
            }
            finalResult /= childvalue;
        }
        byte[] resultPtr = new byte[PDataType.LONG.getByteSize().intValue()];
        this.getDataType().getCodec().encodeLong(finalResult, resultPtr, 0);
        ptr.set(resultPtr);
        return true;
    }

    @Override
    public final PDataType getDataType() {
        return PDataType.LONG;
    }
}

