/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression;

import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.MultiplyExpression;
import org.apache.phoenix.schema.PDataType;
import org.apache.phoenix.schema.tuple.Tuple;

public class LongMultiplyExpression
extends MultiplyExpression {
    public LongMultiplyExpression() {
    }

    public LongMultiplyExpression(List<Expression> children) {
        super(children);
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        long finalResult = 1L;
        for (int i = 0; i < this.children.size(); ++i) {
            Expression child = (Expression)this.children.get(i);
            if (!child.evaluate(tuple, ptr)) {
                return false;
            }
            if (ptr.getLength() == 0) {
                return false;
            }
            long childvalue = child.getDataType().getCodec().decodeLong(ptr, child.getSortOrder());
            finalResult *= childvalue;
        }
        byte[] resultPtr = new byte[this.getDataType().getByteSize().intValue()];
        this.getDataType().getCodec().encodeLong(finalResult, resultPtr, 0);
        ptr.set(resultPtr);
        return true;
    }

    @Override
    public final PDataType getDataType() {
        return PDataType.LONG;
    }
}

