/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression;

import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.SubtractExpression;
import org.apache.phoenix.schema.PDataType;
import org.apache.phoenix.schema.tuple.Tuple;

public class LongSubtractExpression
extends SubtractExpression {
    public LongSubtractExpression() {
    }

    public LongSubtractExpression(List<Expression> children) {
        super(children);
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        long finalResult = 0L;
        for (int i = 0; i < this.children.size(); ++i) {
            Expression child = (Expression)this.children.get(i);
            if (!child.evaluate(tuple, ptr) || ptr.getLength() == 0) {
                return false;
            }
            PDataType childType = child.getDataType();
            boolean isDate = childType.isCoercibleTo(PDataType.DATE);
            long childvalue = childType.getCodec().decodeLong(ptr, child.getSortOrder());
            if (i == 0) {
                finalResult = childvalue;
                continue;
            }
            finalResult -= childvalue;
            if (!isDate) continue;
            finalResult /= 86400000L;
        }
        byte[] resultPtr = new byte[this.getDataType().getByteSize().intValue()];
        this.getDataType().getCodec().encodeLong(finalResult, resultPtr, 0);
        ptr.set(resultPtr);
        return true;
    }

    @Override
    public final PDataType getDataType() {
        return PDataType.LONG;
    }
}

