/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.ColumnExpression;
import org.apache.phoenix.expression.visitor.ExpressionVisitor;
import org.apache.phoenix.join.ScanProjector;
import org.apache.phoenix.schema.KeyValueSchema;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.ValueBitSet;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.util.SchemaUtil;

public class ProjectedColumnExpression
extends ColumnExpression {
    private KeyValueSchema schema;
    ValueBitSet bitSet;
    private int position;
    private String displayName;

    public ProjectedColumnExpression() {
    }

    public ProjectedColumnExpression(PColumn column, PTable table, String displayName) {
        super(column);
        this.schema = ProjectedColumnExpression.buildSchema(table);
        this.bitSet = ValueBitSet.newInstance(this.schema);
        this.position = column.getPosition() - table.getPKColumns().size();
        this.displayName = displayName;
    }

    private static KeyValueSchema buildSchema(PTable table) {
        KeyValueSchema.KeyValueSchemaBuilder builder = new KeyValueSchema.KeyValueSchemaBuilder(0);
        for (PColumn column : table.getColumns()) {
            if (SchemaUtil.isPKColumn(column)) continue;
            builder.addField(column);
        }
        return builder.build();
    }

    public KeyValueSchema getSchema() {
        return this.schema;
    }

    public int getPosition() {
        return this.position;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.schema.hashCode();
        result = 31 * result + this.position;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProjectedColumnExpression other = (ProjectedColumnExpression)obj;
        if (!this.schema.equals(other.schema)) {
            return false;
        }
        return this.position == other.position;
    }

    public String toString() {
        return this.displayName;
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        try {
            ScanProjector.decodeProjectedValue(tuple, ptr);
            int maxOffset = ptr.getOffset() + ptr.getLength();
            this.bitSet.clear();
            this.bitSet.or(ptr);
            this.schema.iterator(ptr, this.position, this.bitSet);
            Boolean hasValue = this.schema.next(ptr, this.position, maxOffset, this.bitSet);
            if (hasValue == null || !hasValue.booleanValue()) {
                return false;
            }
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    @Override
    public void readFields(DataInput input) throws IOException {
        super.readFields(input);
        this.schema = new KeyValueSchema();
        this.schema.readFields(input);
        this.bitSet = ValueBitSet.newInstance(this.schema);
        this.position = input.readInt();
        this.displayName = input.readUTF();
    }

    @Override
    public void write(DataOutput output) throws IOException {
        super.write(output);
        this.schema.write(output);
        output.writeInt(this.position);
        output.writeUTF(this.displayName);
    }

    @Override
    public final <T> T accept(ExpressionVisitor<T> visitor) {
        return visitor.visit(this);
    }
}

