/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression;

import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.BaseCompoundExpression;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.visitor.ExpressionVisitor;
import org.apache.phoenix.schema.PDataType;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.util.ByteUtil;

public class StringConcatExpression
extends BaseCompoundExpression {
    public StringConcatExpression() {
    }

    public StringConcatExpression(List<Expression> children) {
        super(children);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder("(");
        for (int i = 0; i < this.children.size() - 1; ++i) {
            buf.append(this.children.get(i) + " || ");
        }
        buf.append(this.children.get(this.children.size() - 1));
        buf.append(')');
        return buf.toString();
    }

    @Override
    public final <T> T accept(ExpressionVisitor<T> visitor) {
        List<T> l = this.acceptChildren(visitor, visitor.visitEnter(this));
        T t = visitor.visitLeave(this, l);
        if (t == null) {
            t = visitor.defaultReturn(this, l);
        }
        return t;
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        byte[] result = ByteUtil.EMPTY_BYTE_ARRAY;
        for (int i = 0; i < this.children.size(); ++i) {
            if (((Expression)this.children.get(i)).getDataType() == null || !((Expression)this.children.get(i)).evaluate(tuple, ptr)) continue;
            PDataType childType = ((Expression)this.children.get(i)).getDataType();
            SortOrder sortOrder = ((Expression)this.children.get(i)).getSortOrder();
            result = childType.isCoercibleTo(PDataType.VARCHAR) ? ByteUtil.concat(result, new byte[][]{ByteUtil.concat(sortOrder, ptr)}) : ByteUtil.concat(result, new byte[][]{PDataType.VARCHAR.toBytes(childType.toObject(ptr, sortOrder).toString())});
        }
        ptr.set(result);
        return true;
    }

    @Override
    public PDataType getDataType() {
        return PDataType.VARCHAR;
    }
}

