/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.AddExpression;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.PDataType;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.util.DateUtil;

public class TimestampAddExpression
extends AddExpression {
    public TimestampAddExpression() {
    }

    public TimestampAddExpression(List<Expression> children) {
        super(children);
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        BigDecimal finalResult = BigDecimal.ZERO;
        for (int i = 0; i < this.children.size(); ++i) {
            if (!((Expression)this.children.get(i)).evaluate(tuple, ptr)) {
                return false;
            }
            if (ptr.getLength() == 0) {
                return true;
            }
            PDataType type = ((Expression)this.children.get(i)).getDataType();
            SortOrder sortOrder = ((Expression)this.children.get(i)).getSortOrder();
            BigDecimal value = type == PDataType.TIMESTAMP || type == PDataType.UNSIGNED_TIMESTAMP ? (BigDecimal)PDataType.DECIMAL.toObject(ptr, type, sortOrder) : (type.isCoercibleTo(PDataType.DECIMAL) ? ((BigDecimal)PDataType.DECIMAL.toObject(ptr, sortOrder)).multiply(QueryConstants.BD_MILLIS_IN_DAY).setScale(6, RoundingMode.HALF_UP) : (type.isCoercibleTo(PDataType.DOUBLE) ? BigDecimal.valueOf(type.getCodec().decodeDouble(ptr, sortOrder)).multiply(QueryConstants.BD_MILLIS_IN_DAY).setScale(6, RoundingMode.HALF_UP) : BigDecimal.valueOf(type.getCodec().decodeLong(ptr, sortOrder))));
            finalResult = finalResult.add(value);
        }
        Timestamp ts = DateUtil.getTimestamp(finalResult);
        byte[] resultPtr = new byte[this.getDataType().getByteSize().intValue()];
        PDataType.TIMESTAMP.toBytes(ts, resultPtr, 0);
        ptr.set(resultPtr);
        return true;
    }

    @Override
    public final PDataType getDataType() {
        return PDataType.TIMESTAMP;
    }
}

