/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.aggregator;

import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.aggregator.BaseAggregator;
import org.apache.phoenix.expression.aggregator.LongSumAggregator;
import org.apache.phoenix.schema.PDataType;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.tuple.Tuple;

public class CountAggregator
extends BaseAggregator {
    private long count = 0L;
    private byte[] buffer = null;

    public CountAggregator() {
        super(SortOrder.getDefault());
    }

    public CountAggregator(LongSumAggregator clientAgg) {
        this();
        this.count = clientAgg.getSum();
    }

    @Override
    public void aggregate(Tuple tuple, ImmutableBytesWritable ptr) {
        ++this.count;
    }

    @Override
    public boolean isNullable() {
        return false;
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        if (this.buffer == null) {
            this.buffer = new byte[this.getDataType().getByteSize().intValue()];
        }
        this.getDataType().getCodec().encodeLong(this.count, this.buffer, 0);
        ptr.set(this.buffer);
        return true;
    }

    @Override
    public final PDataType getDataType() {
        return PDataType.LONG;
    }

    @Override
    public void reset() {
        this.count = 0L;
        this.buffer = null;
        super.reset();
    }

    public String toString() {
        return "COUNT [count=" + this.count + "]";
    }

    @Override
    public int getSize() {
        return super.getSize() + 8 + 24 + this.getDataType().getByteSize();
    }
}

