/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.aggregator;

import java.math.BigDecimal;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.aggregator.BaseAggregator;
import org.apache.phoenix.schema.PDataType;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.tuple.Tuple;

public class DecimalSumAggregator
extends BaseAggregator {
    private BigDecimal sum = BigDecimal.ZERO;
    private byte[] sumBuffer;

    public DecimalSumAggregator(SortOrder sortOrder, ImmutableBytesWritable ptr) {
        super(sortOrder);
        if (ptr != null) {
            this.initBuffer();
            this.sum = (BigDecimal)PDataType.DECIMAL.toObject(ptr);
        }
    }

    private PDataType getInputDataType() {
        return PDataType.DECIMAL;
    }

    private int getBufferLength() {
        return this.getDataType().getByteSize();
    }

    private void initBuffer() {
        this.sumBuffer = new byte[this.getBufferLength()];
    }

    @Override
    public void aggregate(Tuple tuple, ImmutableBytesWritable ptr) {
        BigDecimal value = (BigDecimal)this.getDataType().toObject(ptr, this.getInputDataType(), this.sortOrder);
        this.sum = this.sum.add(value);
        if (this.sumBuffer == null) {
            this.sumBuffer = new byte[this.getDataType().getByteSize().intValue()];
        }
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        if (this.sumBuffer == null) {
            return false;
        }
        int len = this.getDataType().toBytes(this.sum, this.sumBuffer, 0);
        ptr.set(this.sumBuffer, 0, len);
        return true;
    }

    @Override
    public final PDataType getDataType() {
        return PDataType.DECIMAL;
    }

    @Override
    public void reset() {
        this.sum = BigDecimal.ZERO;
        this.sumBuffer = null;
        super.reset();
    }

    public String toString() {
        return "DECIMAL SUM [sum=" + this.sum + "]";
    }

    @Override
    public int getSize() {
        return super.getSize() + 116 + 24 + this.getDataType().getByteSize();
    }
}

