/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.aggregator;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.WritableUtils;
import org.apache.phoenix.expression.aggregator.BaseAggregator;
import org.apache.phoenix.expression.aggregator.DistinctValueWithCountServerAggregator;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.schema.PDataType;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.tuple.SingleKeyValueTuple;
import org.apache.phoenix.schema.tuple.Tuple;

public abstract class DistinctValueWithCountClientAggregator
extends BaseAggregator {
    protected Map<ImmutableBytesPtr, Integer> valueVsCount = new HashMap<ImmutableBytesPtr, Integer>();
    protected byte[] buffer;
    protected long totalCount = 0L;
    protected Object cachedResult;

    public DistinctValueWithCountClientAggregator(SortOrder sortOrder) {
        super(sortOrder);
    }

    @Override
    public void aggregate(Tuple tuple, ImmutableBytesWritable ptr) {
        if (tuple instanceof SingleKeyValueTuple) {
            PDataType resultDataType = this.getResultDataType();
            this.cachedResult = resultDataType.toObject(ptr, resultDataType, this.sortOrder);
        } else {
            InputStream is = new ByteArrayInputStream(ptr.get(), ptr.getOffset() + 1, ptr.getLength() - 1);
            try {
                if (Bytes.equals(ptr.get(), ptr.getOffset(), 1, DistinctValueWithCountServerAggregator.COMPRESS_MARKER, 0, 1)) {
                    InputStream decompressionStream = DistinctValueWithCountServerAggregator.COMPRESS_ALGO.createDecompressionStream(is, DistinctValueWithCountServerAggregator.COMPRESS_ALGO.getDecompressor(), 0);
                    is = decompressionStream;
                }
                DataInputStream in = new DataInputStream(is);
                int mapSize = WritableUtils.readVInt(in);
                for (int i = 0; i < mapSize; ++i) {
                    int keyLen = WritableUtils.readVInt(in);
                    byte[] keyBytes = new byte[keyLen];
                    in.read(keyBytes, 0, keyLen);
                    ImmutableBytesPtr key = new ImmutableBytesPtr(keyBytes);
                    int value = WritableUtils.readVInt(in);
                    Integer curCount = this.valueVsCount.get(key);
                    if (curCount == null) {
                        this.valueVsCount.put(key, value);
                    } else {
                        this.valueVsCount.put(key, curCount + value);
                    }
                    this.totalCount += (long)value;
                }
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
        if (this.buffer == null) {
            this.initBuffer();
        }
    }

    protected void initBuffer() {
        this.buffer = new byte[this.getBufferLength()];
    }

    @Override
    public boolean isNullable() {
        return false;
    }

    @Override
    public PDataType getDataType() {
        return PDataType.VARBINARY;
    }

    @Override
    public void reset() {
        this.valueVsCount = new HashMap<ImmutableBytesPtr, Integer>();
        this.buffer = null;
        this.totalCount = 0L;
        this.cachedResult = null;
        super.reset();
    }

    protected Map<Object, Integer> getSortedValueVsCount(final boolean ascending, final PDataType type) {
        Comparator<Object> comparator = new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                if (ascending) {
                    return type.compareTo(o1, o2);
                }
                return type.compareTo(o2, o1);
            }
        };
        TreeMap<Object, Integer> sorted = new TreeMap<Object, Integer>(comparator);
        for (Map.Entry<ImmutableBytesPtr, Integer> entry : this.valueVsCount.entrySet()) {
            sorted.put(type.toObject((ImmutableBytesWritable)entry.getKey(), this.sortOrder), entry.getValue());
        }
        return sorted;
    }

    protected int getBufferLength() {
        return this.getResultDataType().getByteSize();
    }

    protected abstract PDataType getResultDataType();
}

