/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.aggregator;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.phoenix.expression.aggregator.BaseAggregator;
import org.apache.phoenix.expression.aggregator.DistinctValueWithCountClientAggregator;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.schema.PDataType;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.SizedUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistinctValueWithCountServerAggregator
extends BaseAggregator {
    private static final Logger LOG = LoggerFactory.getLogger(DistinctValueWithCountServerAggregator.class);
    public static final int DEFAULT_ESTIMATED_DISTINCT_VALUES = 10000;
    public static final byte[] COMPRESS_MARKER = new byte[]{1};
    public static final Compression.Algorithm COMPRESS_ALGO = Compression.Algorithm.SNAPPY;
    private int compressThreshold;
    private byte[] buffer = null;
    private Map<ImmutableBytesPtr, Integer> valueVsCount = new HashMap<ImmutableBytesPtr, Integer>();

    public DistinctValueWithCountServerAggregator(Configuration conf) {
        super(SortOrder.getDefault());
        this.compressThreshold = conf.getInt("phoenix.distinct.value.compress.threshold", 0x100000);
    }

    public DistinctValueWithCountServerAggregator(Configuration conf, DistinctValueWithCountClientAggregator clientAgg) {
        this(conf);
        this.valueVsCount = clientAgg.valueVsCount;
    }

    @Override
    public void aggregate(Tuple tuple, ImmutableBytesWritable ptr) {
        ImmutableBytesPtr key = new ImmutableBytesPtr(ptr.get(), ptr.getOffset(), ptr.getLength());
        Integer count = this.valueVsCount.get(key);
        if (count == null) {
            this.valueVsCount.put(key, 1);
        } else {
            count = count + 1;
            this.valueVsCount.put(key, count);
        }
    }

    @Override
    public boolean isNullable() {
        return false;
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        int serializationSize = this.countMapSerializationSize();
        this.buffer = new byte[serializationSize];
        int offset = 1;
        offset += ByteUtil.vintToBytes(this.buffer, offset, this.valueVsCount.size());
        for (Map.Entry<ImmutableBytesPtr, Integer> entry : this.valueVsCount.entrySet()) {
            ImmutableBytesPtr key = entry.getKey();
            offset += ByteUtil.vintToBytes(this.buffer, offset, key.getLength());
            System.arraycopy(key.get(), key.getOffset(), this.buffer, offset, key.getLength());
            offset += key.getLength();
            offset += ByteUtil.vintToBytes(this.buffer, offset, entry.getValue().intValue());
        }
        if (serializationSize > this.compressThreshold) {
            ByteArrayOutputStream compressedByteStream = new ByteArrayOutputStream();
            try {
                compressedByteStream.write(COMPRESS_MARKER);
                OutputStream compressionStream = COMPRESS_ALGO.createCompressionStream(compressedByteStream, COMPRESS_ALGO.getCompressor(), 0);
                compressionStream.write(this.buffer, 1, this.buffer.length - 1);
                compressionStream.flush();
                ptr.set(compressedByteStream.toByteArray(), 0, compressedByteStream.size());
                return true;
            }
            catch (Exception e) {
                LOG.error("Exception while Snappy compression of data.", e);
            }
        }
        ptr.set(this.buffer, 0, offset);
        return true;
    }

    private int countMapSerializationSize() {
        int size = 4;
        for (ImmutableBytesPtr key : this.valueVsCount.keySet()) {
            size += key.getLength() + 4 + 4;
        }
        return size;
    }

    private int countMapHeapSize() {
        int size = 0;
        if (this.valueVsCount.size() > 0) {
            for (ImmutableBytesPtr key : this.valueVsCount.keySet()) {
                size += 48 + key.getLength() + 24;
            }
        } else {
            SizedUtil.sizeOfMap(10000, 52, 4);
        }
        return size;
    }

    @Override
    public final PDataType getDataType() {
        return PDataType.VARBINARY;
    }

    @Override
    public void reset() {
        this.valueVsCount = new HashMap<ImmutableBytesPtr, Integer>();
        this.buffer = null;
        super.reset();
    }

    public String toString() {
        return "DISTINCT VALUE vs COUNT";
    }

    @Override
    public int getSize() {
        return super.getSize() + 24 + this.countMapHeapSize();
    }
}

