/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.function;

import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.function.ScalarFunction;
import org.apache.phoenix.parse.FunctionParseNode;
import org.apache.phoenix.parse.ParseException;
import org.apache.phoenix.schema.PArrayDataType;
import org.apache.phoenix.schema.PDataType;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.tuple.Tuple;

@FunctionParseNode.BuiltInFunction(name="ARRAY_ELEM", args={@FunctionParseNode.Argument(allowedTypes={PDataType.BINARY_ARRAY, PDataType.VARBINARY_ARRAY}), @FunctionParseNode.Argument(allowedTypes={PDataType.INTEGER})})
public class ArrayIndexFunction
extends ScalarFunction {
    public static final String NAME = "ARRAY_ELEM";

    public ArrayIndexFunction() {
    }

    public ArrayIndexFunction(List<Expression> children) {
        super(children);
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        Expression indexExpr = (Expression)this.children.get(1);
        if (!indexExpr.evaluate(tuple, ptr)) {
            return false;
        }
        if (ptr.getLength() == 0) {
            return true;
        }
        int index = PDataType.INTEGER.getCodec().decodeInt(ptr, indexExpr.getSortOrder());
        if (index < 0) {
            throw new ParseException("Index cannot be negative :" + index);
        }
        Expression arrayExpr = (Expression)this.children.get(0);
        if (!arrayExpr.evaluate(tuple, ptr)) {
            return false;
        }
        if (ptr.getLength() == 0) {
            return true;
        }
        PArrayDataType.positionAtArrayElement(ptr, index - 1, this.getDataType(), this.getMaxLength());
        return true;
    }

    @Override
    public PDataType getDataType() {
        return PDataType.fromTypeId(((Expression)this.children.get(0)).getDataType().getSqlType() - 3000);
    }

    @Override
    public Integer getMaxLength() {
        return ((Expression)this.children.get(0)).getMaxLength();
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public SortOrder getSortOrder() {
        return ((Expression)this.children.get(0)).getSortOrder();
    }
}

