/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.function;

import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.function.ScalarFunction;
import org.apache.phoenix.parse.FunctionParseNode;
import org.apache.phoenix.schema.PArrayDataType;
import org.apache.phoenix.schema.PDataType;
import org.apache.phoenix.schema.tuple.Tuple;

@FunctionParseNode.BuiltInFunction(name="ARRAY_LENGTH", args={@FunctionParseNode.Argument(allowedTypes={PDataType.BINARY_ARRAY, PDataType.VARBINARY_ARRAY})})
public class ArrayLengthFunction
extends ScalarFunction {
    public static final String NAME = "ARRAY_LENGTH";

    public ArrayLengthFunction() {
    }

    public ArrayLengthFunction(List<Expression> children) {
        super(children);
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        Expression arrayExpr = (Expression)this.children.get(0);
        if (!arrayExpr.evaluate(tuple, ptr)) {
            return false;
        }
        if (ptr.getLength() == 0) {
            return true;
        }
        PDataType baseType = PDataType.fromTypeId(((Expression)this.children.get(0)).getDataType().getSqlType() - 3000);
        int length = PArrayDataType.getArrayLength(ptr, baseType, arrayExpr.getMaxLength());
        byte[] lengthBuf = new byte[PDataType.INTEGER.getByteSize().intValue()];
        PDataType.INTEGER.getCodec().encodeInt(length, lengthBuf, 0);
        ptr.set(lengthBuf);
        return true;
    }

    @Override
    public PDataType getDataType() {
        return PDataType.INTEGER;
    }

    @Override
    public String getName() {
        return NAME;
    }
}

