/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.function;

import java.math.BigDecimal;
import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.expression.function.CompositeAggregateFunction;
import org.apache.phoenix.expression.function.CountAggregateFunction;
import org.apache.phoenix.expression.function.SumAggregateFunction;
import org.apache.phoenix.parse.AvgAggregateParseNode;
import org.apache.phoenix.parse.FunctionParseNode;
import org.apache.phoenix.schema.PDataType;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.tuple.Tuple;

@FunctionParseNode.BuiltInFunction(name="AVG", nodeClass=AvgAggregateParseNode.class, args={@FunctionParseNode.Argument(allowedTypes={PDataType.DECIMAL})})
public class AvgAggregateFunction
extends CompositeAggregateFunction {
    public static final String NAME = "AVG";
    private final CountAggregateFunction countFunc;
    private final SumAggregateFunction sumFunc;
    private Integer scale;

    public AvgAggregateFunction(List<Expression> children) {
        super(children);
        this.countFunc = null;
        this.sumFunc = null;
        this.setScale(children);
    }

    public AvgAggregateFunction(List<Expression> children, CountAggregateFunction countFunc, SumAggregateFunction sumFunc) {
        super(children);
        this.countFunc = countFunc;
        this.sumFunc = sumFunc;
        this.setScale(children);
    }

    private void setScale(List<Expression> children) {
        this.scale = 4;
        for (Expression child : children) {
            if (child.getScale() == null) continue;
            this.scale = Math.max(this.scale, child.getScale());
        }
    }

    @Override
    public PDataType getDataType() {
        return PDataType.DECIMAL;
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        if (!this.countFunc.evaluate(tuple, ptr)) {
            return false;
        }
        long count = this.countFunc.getDataType().getCodec().decodeLong(ptr, SortOrder.getDefault());
        if (count == 0L) {
            return false;
        }
        if (!this.countFunc.isConstantExpression()) {
            this.sumFunc.evaluate(tuple, ptr);
            BigDecimal sum = (BigDecimal)PDataType.DECIMAL.toObject(ptr, this.sumFunc.getDataType());
            BigDecimal avg = sum.divide(BigDecimal.valueOf(count), PDataType.DEFAULT_MATH_CONTEXT);
            avg = avg.setScale((int)this.scale, 1);
            ptr.set(PDataType.DECIMAL.toBytes(avg));
            return true;
        }
        BigDecimal value = (BigDecimal)((LiteralExpression)this.countFunc.getChildren().get(0)).getValue();
        value = value.setScale((int)this.scale, 1);
        ptr.set(PDataType.DECIMAL.toBytes(value));
        return true;
    }

    @Override
    public boolean isNullable() {
        return this.sumFunc != null && this.sumFunc.isNullable();
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Integer getScale() {
        return this.scale;
    }
}

