/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.function;

import com.google.common.collect.Lists;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.expression.function.RoundDecimalExpression;
import org.apache.phoenix.schema.PDataType;

public class CeilDecimalExpression
extends RoundDecimalExpression {
    public CeilDecimalExpression() {
    }

    public CeilDecimalExpression(List<Expression> children) {
        super(children);
    }

    public static Expression create(Expression expr, int scale) throws SQLException {
        if (expr.getDataType().isCoercibleTo(PDataType.LONG)) {
            return expr;
        }
        LiteralExpression scaleExpr = LiteralExpression.newConstant((Object)scale, PDataType.INTEGER, true);
        ArrayList<Expression> expressions = Lists.newArrayList(expr, scaleExpr);
        return new CeilDecimalExpression(expressions);
    }

    public static Expression create(Expression expr) throws SQLException {
        return CeilDecimalExpression.create(expr, 0);
    }

    @Override
    protected RoundingMode getRoundingMode() {
        return RoundingMode.CEILING;
    }

    @Override
    public String getName() {
        return "CEIL";
    }
}

