/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.function;

import com.google.common.collect.Lists;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.CoerceExpression;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.expression.function.CeilDateExpression;
import org.apache.phoenix.expression.function.TimeUnit;
import org.apache.phoenix.schema.PDataType;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.tuple.Tuple;

public class CeilTimestampExpression
extends CeilDateExpression {
    public CeilTimestampExpression() {
    }

    private CeilTimestampExpression(List<Expression> children) {
        super(children);
    }

    public static CeilTimestampExpression create(Expression expr, int multiplier) throws SQLException {
        ArrayList<Expression> childExprs = Lists.newArrayList(expr, CeilTimestampExpression.getTimeUnitExpr(TimeUnit.MILLISECOND), CeilTimestampExpression.getMultiplierExpr(multiplier));
        return new CeilTimestampExpression(childExprs);
    }

    public static Expression create(List<Expression> children) throws SQLException {
        Expression firstChild = children.get(0);
        PDataType firstChildDataType = firstChild.getDataType();
        String timeUnit = (String)((LiteralExpression)children.get(1)).getValue();
        if (TimeUnit.MILLISECOND.toString().equalsIgnoreCase(timeUnit)) {
            return new CeilTimestampExpression(children);
        }
        ArrayList<Expression> newChildren = Lists.newArrayListWithExpectedSize(children.size());
        newChildren.add(CoerceExpression.create(firstChild, firstChildDataType == PDataType.TIMESTAMP ? PDataType.DATE : PDataType.UNSIGNED_DATE));
        newChildren.addAll(children.subList(1, children.size()));
        return CeilDateExpression.create(newChildren);
    }

    public static CeilTimestampExpression create(Expression expr) throws SQLException {
        return CeilTimestampExpression.create(expr, 1);
    }

    @Override
    protected PDataType.PDataCodec getKeyRangeCodec(PDataType columnDataType) {
        return columnDataType == PDataType.TIMESTAMP ? PDataType.DATE.getCodec() : (columnDataType == PDataType.UNSIGNED_TIMESTAMP ? PDataType.UNSIGNED_DATE.getCodec() : super.getKeyRangeCodec(columnDataType));
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        if (((Expression)this.children.get(0)).evaluate(tuple, ptr)) {
            SortOrder sortOrder = ((Expression)this.children.get(0)).getSortOrder();
            PDataType dataType = this.getDataType();
            int nanos = dataType.getNanos(ptr, sortOrder);
            if (nanos > 0) {
                long millis = dataType.getMillis(ptr, sortOrder);
                Timestamp roundedTs = new Timestamp(millis + 1L);
                byte[] byteValue = dataType.toBytes(roundedTs);
                ptr.set(byteValue);
            }
            return true;
        }
        return false;
    }
}

