/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.function;

import java.sql.SQLException;
import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.function.ScalarFunction;
import org.apache.phoenix.parse.FunctionParseNode;
import org.apache.phoenix.schema.PDataType;
import org.apache.phoenix.schema.tuple.Tuple;

@FunctionParseNode.BuiltInFunction(name="COALESCE", args={@FunctionParseNode.Argument, @FunctionParseNode.Argument})
public class CoalesceFunction
extends ScalarFunction {
    public static final String NAME = "COALESCE";

    public CoalesceFunction() {
    }

    public CoalesceFunction(List<Expression> children) throws SQLException {
        super(children);
        if (!children.get(1).getDataType().isCoercibleTo(children.get(0).getDataType())) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_CONVERT_TYPE).setMessage(this.getName() + " expected " + (Object)((Object)children.get(0).getDataType()) + ", but got " + (Object)((Object)children.get(1).getDataType())).build().buildException();
        }
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        boolean evaluated = ((Expression)this.children.get(0)).evaluate(tuple, ptr);
        if (evaluated) {
            return true;
        }
        if (tuple.isImmutable()) {
            return ((Expression)this.children.get(1)).evaluate(tuple, ptr);
        }
        return false;
    }

    @Override
    public PDataType getDataType() {
        return ((Expression)this.children.get(0)).getDataType();
    }

    @Override
    public Integer getMaxLength() {
        Integer maxLength2;
        Integer maxLength1 = ((Expression)this.children.get(0)).getMaxLength();
        if (maxLength1 != null && (maxLength2 = ((Expression)this.children.get(1)).getMaxLength()) != null) {
            return maxLength1 > maxLength2 ? maxLength1 : maxLength2;
        }
        return null;
    }

    @Override
    public boolean isNullable() {
        return ((Expression)this.children.get(0)).isNullable() && ((Expression)this.children.get(1)).isNullable();
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean requiresFinalEvaluation() {
        return true;
    }
}

