/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.function;

import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.CurrentDateTimeFunction;
import org.apache.phoenix.parse.CurrentDateParseNode;
import org.apache.phoenix.parse.FunctionParseNode;
import org.apache.phoenix.schema.PDataType;
import org.apache.phoenix.schema.tuple.Tuple;

@FunctionParseNode.BuiltInFunction(name="CURRENT_DATE", nodeClass=CurrentDateParseNode.class, args={})
public class CurrentDateFunction
extends CurrentDateTimeFunction {
    public static final String NAME = "CURRENT_DATE";
    private final ImmutableBytesWritable currentDate = new ImmutableBytesWritable(new byte[PDataType.DATE.getByteSize().intValue()]);

    public CurrentDateFunction() {
        this(System.currentTimeMillis());
    }

    public CurrentDateFunction(long timeStamp) {
        this.getDataType().getCodec().encodeLong(timeStamp, this.currentDate);
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        ptr.set(this.currentDate.get(), 0, PDataType.DATE.getByteSize());
        return true;
    }

    @Override
    public final PDataType getDataType() {
        return PDataType.DATE;
    }

    @Override
    public String getName() {
        return NAME;
    }
}

