/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.function;

import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.function.CountAggregateFunction;
import org.apache.phoenix.expression.function.SingleAggregateFunction;
import org.apache.phoenix.schema.PDataType;
import org.apache.phoenix.schema.tuple.Tuple;

public abstract class DelegateConstantToCountAggregateFunction
extends SingleAggregateFunction {
    private static final ImmutableBytesWritable ZERO = new ImmutableBytesWritable(PDataType.LONG.toBytes(0L));
    private CountAggregateFunction delegate;

    public DelegateConstantToCountAggregateFunction() {
    }

    public DelegateConstantToCountAggregateFunction(List<Expression> childExpressions, CountAggregateFunction delegate) {
        super(childExpressions);
        this.delegate = delegate;
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        if (this.delegate == null) {
            return super.evaluate(tuple, ptr);
        }
        this.delegate.evaluate(tuple, ptr);
        return PDataType.LONG.compareTo(ptr, ZERO) != 0;
    }

    @Override
    protected SingleAggregateFunction getDelegate() {
        return this.delegate != null ? this.delegate : super.getDelegate();
    }
}

