/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.function;

import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.aggregator.Aggregator;
import org.apache.phoenix.expression.aggregator.DistinctCountClientAggregator;
import org.apache.phoenix.expression.aggregator.DistinctValueWithCountServerAggregator;
import org.apache.phoenix.expression.function.CountAggregateFunction;
import org.apache.phoenix.expression.function.DelegateConstantToCountAggregateFunction;
import org.apache.phoenix.parse.FunctionParseNode;
import org.apache.phoenix.schema.PDataType;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.util.SchemaUtil;

@FunctionParseNode.BuiltInFunction(name="DISTINCT_COUNT", args={@FunctionParseNode.Argument})
public class DistinctCountAggregateFunction
extends DelegateConstantToCountAggregateFunction {
    public static final String NAME = "DISTINCT_COUNT";
    public static final String NORMALIZED_NAME = SchemaUtil.normalizeIdentifier("DISTINCT_COUNT");
    public static final byte[] ZERO = PDataType.LONG.toBytes(0L);
    public static final byte[] ONE = PDataType.LONG.toBytes(1L);

    public DistinctCountAggregateFunction() {
    }

    public DistinctCountAggregateFunction(List<Expression> childExpressions) {
        this(childExpressions, null);
    }

    public DistinctCountAggregateFunction(List<Expression> childExpressions, CountAggregateFunction delegate) {
        super(childExpressions, delegate);
        assert (childExpressions.size() == 1);
    }

    @Override
    public int hashCode() {
        return this.isConstantExpression() ? 0 : super.hashCode();
    }

    @Override
    public boolean isNullable() {
        return false;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DistinctCountAggregateFunction other = (DistinctCountAggregateFunction)obj;
        return this.isConstantExpression() && other.isConstantExpression() || ((Object)this.children).equals(other.getChildren());
    }

    @Override
    public PDataType getDataType() {
        return PDataType.LONG;
    }

    @Override
    public DistinctCountClientAggregator newClientAggregator() {
        return new DistinctCountClientAggregator(this.getAggregatorExpression().getSortOrder());
    }

    @Override
    public Aggregator newServerAggregator(Configuration conf) {
        return new DistinctValueWithCountServerAggregator(conf);
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        if (!super.evaluate(tuple, ptr)) {
            ptr.set(ZERO);
        } else if (this.isConstantExpression()) {
            ptr.set(ONE);
        }
        return true;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Aggregator newServerAggregator(Configuration config, ImmutableBytesWritable ptr) {
        DistinctCountClientAggregator clientAgg = this.newClientAggregator();
        clientAgg.aggregate(null, ptr);
        return new DistinctValueWithCountServerAggregator(config, clientAgg);
    }
}

