/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.function;

import com.google.common.collect.Lists;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.phoenix.expression.CoerceExpression;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.function.RoundDateExpression;
import org.apache.phoenix.expression.function.TimeUnit;
import org.apache.phoenix.schema.PDataType;

public class FloorDateExpression
extends RoundDateExpression {
    public FloorDateExpression() {
    }

    private FloorDateExpression(List<Expression> children) {
        super(children);
    }

    public static Expression create(List<Expression> children) throws SQLException {
        Expression firstChild = children.get(0);
        PDataType firstChildDataType = firstChild.getDataType();
        if (firstChildDataType == PDataType.TIMESTAMP || firstChildDataType == PDataType.UNSIGNED_TIMESTAMP) {
            ArrayList<Expression> newChildren = Lists.newArrayListWithExpectedSize(children.size());
            newChildren.add(CoerceExpression.create(firstChild, firstChildDataType == PDataType.TIMESTAMP ? PDataType.DATE : PDataType.UNSIGNED_DATE));
            newChildren.addAll(children.subList(1, children.size()));
            children = newChildren;
        }
        return new FloorDateExpression(children);
    }

    public static Expression create(Expression expr, TimeUnit timeUnit) throws SQLException {
        return FloorDateExpression.create(expr, timeUnit, 1);
    }

    public static Expression create(Expression expr, TimeUnit timeUnit, int multiplier) throws SQLException {
        Expression timeUnitExpr = FloorDateExpression.getTimeUnitExpr(timeUnit);
        Expression defaultMultiplierExpr = FloorDateExpression.getMultiplierExpr(multiplier);
        ArrayList<Expression> expressions = Lists.newArrayList(expr, timeUnitExpr, defaultMultiplierExpr);
        return FloorDateExpression.create(expressions);
    }

    @Override
    protected long getRoundUpAmount() {
        return 0L;
    }

    @Override
    public String getName() {
        return "FLOOR";
    }
}

