/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.function;

import com.google.common.collect.Lists;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.expression.function.RoundDecimalExpression;
import org.apache.phoenix.schema.PDataType;

public class FloorDecimalExpression
extends RoundDecimalExpression {
    public FloorDecimalExpression() {
    }

    public FloorDecimalExpression(List<Expression> children) {
        super(children);
    }

    public static Expression create(Expression expr, int scale) throws SQLException {
        if (expr.getDataType().isCoercibleTo(PDataType.LONG)) {
            return expr;
        }
        LiteralExpression scaleExpr = LiteralExpression.newConstant((Object)scale, PDataType.INTEGER, true);
        ArrayList<Expression> expressions = Lists.newArrayList(expr, scaleExpr);
        return new FloorDecimalExpression(expressions);
    }

    public static Expression create(Expression expr) throws SQLException {
        return FloorDecimalExpression.create(expr, 0);
    }

    @Override
    protected RoundingMode getRoundingMode() {
        return RoundingMode.FLOOR;
    }

    @Override
    public String getName() {
        return "FLOOR";
    }
}

