/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.function;

import java.sql.SQLException;
import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.function.ScalarFunction;
import org.apache.phoenix.parse.FunctionParseNode;
import org.apache.phoenix.schema.PDataType;
import org.apache.phoenix.schema.PIndexState;
import org.apache.phoenix.schema.tuple.Tuple;

@FunctionParseNode.BuiltInFunction(name="IndexStateName", args={@FunctionParseNode.Argument(allowedTypes={PDataType.CHAR})})
public class IndexStateNameFunction
extends ScalarFunction {
    public static final String NAME = "IndexStateName";

    public IndexStateNameFunction() {
    }

    public IndexStateNameFunction(List<Expression> children) throws SQLException {
        super(children);
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        Expression child = (Expression)this.children.get(0);
        if (!child.evaluate(tuple, ptr)) {
            return false;
        }
        if (ptr.getLength() == 0) {
            return true;
        }
        byte serializedByte = ptr.get()[ptr.getOffset()];
        PIndexState indexState = PIndexState.fromSerializedValue(serializedByte);
        ptr.set(indexState.toBytes());
        return true;
    }

    @Override
    public PDataType getDataType() {
        return PDataType.VARCHAR;
    }

    @Override
    public String getName() {
        return NAME;
    }
}

