/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.function;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.function.ScalarFunction;
import org.apache.phoenix.parse.FunctionParseNode;
import org.apache.phoenix.schema.PDataType;
import org.apache.phoenix.schema.tuple.Tuple;

@FunctionParseNode.BuiltInFunction(name="MD5", args={@FunctionParseNode.Argument})
public class MD5Function
extends ScalarFunction {
    public static final String NAME = "MD5";
    public static final Integer LENGTH = 16;
    private final MessageDigest messageDigest;

    public MD5Function() throws SQLException {
        try {
            this.messageDigest = MessageDigest.getInstance(NAME);
        }
        catch (NoSuchAlgorithmException e) {
            throw new SQLException(e);
        }
    }

    public MD5Function(List<Expression> children) throws SQLException {
        super(children);
        try {
            this.messageDigest = MessageDigest.getInstance(NAME);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        if (!this.getChildExpression().evaluate(tuple, ptr)) {
            return false;
        }
        this.messageDigest.update(ptr.get(), ptr.getOffset(), ptr.getLength());
        ptr.set(this.messageDigest.digest());
        return true;
    }

    @Override
    public PDataType getDataType() {
        return PDataType.BINARY;
    }

    @Override
    public Integer getMaxLength() {
        return LENGTH;
    }

    @Override
    public boolean isNullable() {
        return this.getChildExpression().isNullable();
    }

    @Override
    public String getName() {
        return NAME;
    }

    private Expression getChildExpression() {
        return (Expression)this.children.get(0);
    }
}

