/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.function;

import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.aggregator.Aggregator;
import org.apache.phoenix.expression.aggregator.MinAggregator;
import org.apache.phoenix.expression.function.CountAggregateFunction;
import org.apache.phoenix.expression.function.DelegateConstantToCountAggregateFunction;
import org.apache.phoenix.parse.FunctionParseNode;
import org.apache.phoenix.parse.MinAggregateParseNode;
import org.apache.phoenix.schema.PDataType;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.tuple.Tuple;

@FunctionParseNode.BuiltInFunction(name="MIN", nodeClass=MinAggregateParseNode.class, args={@FunctionParseNode.Argument})
public class MinAggregateFunction
extends DelegateConstantToCountAggregateFunction {
    public static final String NAME = "MIN";

    public MinAggregateFunction() {
    }

    public MinAggregateFunction(List<Expression> childExpressions, CountAggregateFunction delegate) {
        super(childExpressions, delegate);
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        boolean wasEvaluated = super.evaluate(tuple, ptr);
        if (!wasEvaluated) {
            return false;
        }
        if (this.isConstantExpression()) {
            this.getAggregatorExpression().evaluate(tuple, ptr);
        }
        return true;
    }

    @Override
    public Aggregator newServerAggregator(Configuration conf) {
        final PDataType type = this.getAggregatorExpression().getDataType();
        SortOrder sortOrder = this.getAggregatorExpression().getSortOrder();
        return new MinAggregator(sortOrder){

            @Override
            public PDataType getDataType() {
                return type;
            }
        };
    }

    @Override
    public SortOrder getSortOrder() {
        return this.getAggregatorExpression().getSortOrder();
    }

    @Override
    public String getName() {
        return NAME;
    }
}

