/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.function;

import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.compile.KeyPart;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.function.FunctionExpression;
import org.apache.phoenix.expression.function.ScalarFunction;
import org.apache.phoenix.query.KeyRange;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PDataType;
import org.apache.phoenix.util.ByteUtil;

public abstract class PrefixFunction
extends ScalarFunction {
    public PrefixFunction() {
    }

    public PrefixFunction(List<Expression> children) {
        super(children);
    }

    @Override
    public int getKeyFormationTraversalIndex() {
        return this.preservesOrder() == FunctionExpression.OrderPreserving.NO ? -1 : 0;
    }

    protected boolean extractNode() {
        return false;
    }

    private static byte[] evaluateExpression(Expression rhs) {
        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        rhs.evaluate(null, ptr);
        byte[] key = ByteUtil.copyKeyBytesIfNecessary(ptr);
        return key;
    }

    @Override
    public KeyPart newKeyPart(final KeyPart childPart) {
        return new KeyPart(){
            private final List<Expression> extractNodes;
            {
                this.extractNodes = PrefixFunction.this.extractNode() ? Collections.singletonList(PrefixFunction.this) : Collections.emptyList();
            }

            @Override
            public PColumn getColumn() {
                return childPart.getColumn();
            }

            @Override
            public List<Expression> getExtractNodes() {
                return this.extractNodes;
            }

            @Override
            public KeyRange getKeyRange(CompareFilter.CompareOp op, Expression rhs) {
                KeyRange range;
                PDataType type = this.getColumn().getDataType();
                switch (op) {
                    case EQUAL: {
                        byte[] key = PrefixFunction.evaluateExpression(rhs);
                        range = type.getKeyRange(key, true, ByteUtil.nextKey(key), false);
                        break;
                    }
                    case GREATER: {
                        byte[] key = PrefixFunction.evaluateExpression(rhs);
                        range = type.getKeyRange(ByteUtil.nextKey(key), true, KeyRange.UNBOUND, false);
                        break;
                    }
                    case LESS_OR_EQUAL: {
                        byte[] key = PrefixFunction.evaluateExpression(rhs);
                        range = type.getKeyRange(KeyRange.UNBOUND, false, ByteUtil.nextKey(key), false);
                        break;
                    }
                    default: {
                        return childPart.getKeyRange(op, rhs);
                    }
                }
                Integer length = this.getColumn().getMaxLength();
                return length == null || !type.isFixedWidth() ? range : range.fill(length);
            }
        };
    }
}

