/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.function;

import java.io.DataInput;
import java.io.IOException;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.expression.function.ScalarFunction;
import org.apache.phoenix.parse.FunctionParseNode;
import org.apache.phoenix.schema.PDataType;
import org.apache.phoenix.schema.tuple.Tuple;

@FunctionParseNode.BuiltInFunction(name="REGEXP_REPLACE", args={@FunctionParseNode.Argument(allowedTypes={PDataType.VARCHAR}), @FunctionParseNode.Argument(allowedTypes={PDataType.VARCHAR}), @FunctionParseNode.Argument(allowedTypes={PDataType.VARCHAR}, defaultValue="null")})
public class RegexpReplaceFunction
extends ScalarFunction {
    public static final String NAME = "REGEXP_REPLACE";
    private boolean hasReplaceStr;
    private Pattern pattern;

    public RegexpReplaceFunction() {
    }

    public RegexpReplaceFunction(List<Expression> children) {
        super(children);
        this.init();
    }

    private void init() {
        this.hasReplaceStr = ((LiteralExpression)this.getReplaceStrExpression()).getValue() != null;
        Object patternString = ((LiteralExpression)this.children.get(1)).getValue();
        if (patternString != null) {
            this.pattern = Pattern.compile((String)patternString);
        }
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        String replaceStr;
        if (this.pattern == null) {
            return false;
        }
        Expression sourceStrExpression = this.getSourceStrExpression();
        if (!sourceStrExpression.evaluate(tuple, ptr)) {
            return false;
        }
        String sourceStr = (String)PDataType.VARCHAR.toObject(ptr, sourceStrExpression.getSortOrder());
        if (sourceStr == null) {
            return false;
        }
        if (this.hasReplaceStr) {
            Expression replaceStrExpression = this.getReplaceStrExpression();
            if (!replaceStrExpression.evaluate(tuple, ptr)) {
                return false;
            }
            replaceStr = (String)PDataType.VARCHAR.toObject(ptr, replaceStrExpression.getSortOrder());
        } else {
            replaceStr = "";
        }
        String replacedStr = this.pattern.matcher(sourceStr).replaceAll(replaceStr);
        ptr.set(PDataType.VARCHAR.toBytes(replacedStr));
        return true;
    }

    private Expression getSourceStrExpression() {
        return (Expression)this.children.get(0);
    }

    private Expression getReplaceStrExpression() {
        return (Expression)this.children.get(2);
    }

    @Override
    public PDataType getDataType() {
        return PDataType.VARCHAR;
    }

    @Override
    public void readFields(DataInput input) throws IOException {
        super.readFields(input);
        this.init();
    }

    @Override
    public String getName() {
        return NAME;
    }
}

