/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.function;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.expression.function.FunctionExpression;
import org.apache.phoenix.expression.function.PrefixFunction;
import org.apache.phoenix.parse.FunctionParseNode;
import org.apache.phoenix.schema.PDataType;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.util.ByteUtil;

@FunctionParseNode.BuiltInFunction(name="REGEXP_SUBSTR", args={@FunctionParseNode.Argument(allowedTypes={PDataType.VARCHAR}), @FunctionParseNode.Argument(allowedTypes={PDataType.VARCHAR}), @FunctionParseNode.Argument(allowedTypes={PDataType.LONG}, defaultValue="1")})
public class RegexpSubstrFunction
extends PrefixFunction {
    public static final String NAME = "REGEXP_SUBSTR";
    private Pattern pattern;
    private boolean isOffsetConstant;
    private Integer maxLength;

    public RegexpSubstrFunction() {
    }

    public RegexpSubstrFunction(List<Expression> children) {
        super(children);
        this.init();
    }

    private void init() {
        Object patternString = ((LiteralExpression)this.children.get(1)).getValue();
        if (patternString != null) {
            this.pattern = Pattern.compile((String)patternString);
        }
        this.isOffsetConstant = this.getOffsetExpression() instanceof LiteralExpression;
        Number offsetNumber = (Number)((LiteralExpression)this.getOffsetExpression()).getValue();
        if (offsetNumber != null) {
            int offset = offsetNumber.intValue();
            PDataType type = this.getSourceStrExpression().getDataType();
            if (type.isFixedWidth()) {
                if (offset >= 0) {
                    Integer maxLength = this.getSourceStrExpression().getMaxLength();
                    this.maxLength = maxLength - offset - (offset == 0 ? 0 : 1);
                } else {
                    this.maxLength = -offset;
                }
            }
        }
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        if (this.pattern == null) {
            return false;
        }
        if (!this.getSourceStrExpression().evaluate(tuple, ptr)) {
            return false;
        }
        String sourceStr = (String)PDataType.VARCHAR.toObject(ptr, this.getSourceStrExpression().getSortOrder());
        if (sourceStr == null) {
            return false;
        }
        Expression offsetExpression = this.getOffsetExpression();
        if (!offsetExpression.evaluate(tuple, ptr)) {
            return false;
        }
        int offset = offsetExpression.getDataType().getCodec().decodeInt(ptr, offsetExpression.getSortOrder());
        int strlen = sourceStr.length();
        if ((offset -= offset <= 0 ? 0 : 1) < 0) {
            offset = strlen + offset;
        }
        if (offset < 0 || offset >= strlen) {
            return false;
        }
        Matcher matcher = this.pattern.matcher(sourceStr);
        boolean hasSubString = matcher.find(offset);
        if (!hasSubString) {
            ptr.set(ByteUtil.EMPTY_BYTE_ARRAY);
            return true;
        }
        String subString = matcher.group();
        ptr.set(PDataType.VARCHAR.toBytes(subString));
        return true;
    }

    @Override
    public Integer getMaxLength() {
        return this.maxLength;
    }

    @Override
    public FunctionExpression.OrderPreserving preservesOrder() {
        int offset;
        LiteralExpression literal;
        Number offsetNumber;
        if (this.isOffsetConstant && (offsetNumber = (Number)(literal = (LiteralExpression)this.getOffsetExpression()).getValue()) != null && ((offset = offsetNumber.intValue()) == 0 || offset == 1)) {
            return FunctionExpression.OrderPreserving.YES_IF_LAST;
        }
        return FunctionExpression.OrderPreserving.NO;
    }

    @Override
    public int getKeyFormationTraversalIndex() {
        return this.preservesOrder() == FunctionExpression.OrderPreserving.NO ? -1 : 0;
    }

    private Expression getOffsetExpression() {
        return (Expression)this.children.get(2);
    }

    private Expression getSourceStrExpression() {
        return (Expression)this.children.get(0);
    }

    @Override
    public PDataType getDataType() {
        return PDataType.VARCHAR;
    }

    @Override
    public String getName() {
        return NAME;
    }
}

