/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.function;

import com.google.common.collect.Lists;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.expression.function.FunctionExpression;
import org.apache.phoenix.expression.function.ScalarFunction;
import org.apache.phoenix.schema.IllegalDataException;
import org.apache.phoenix.schema.PDataType;
import org.apache.phoenix.schema.tuple.Tuple;

public class RoundDecimalExpression
extends ScalarFunction {
    private int scale;

    public static Expression create(Expression expr, int scale) throws SQLException {
        if (expr.getDataType().isCoercibleTo(PDataType.LONG)) {
            return expr;
        }
        LiteralExpression scaleExpr = LiteralExpression.newConstant((Object)scale, PDataType.INTEGER, true);
        ArrayList<Expression> expressions = Lists.newArrayList(expr, scaleExpr);
        return new RoundDecimalExpression(expressions);
    }

    public static Expression create(Expression expr) throws SQLException {
        return RoundDecimalExpression.create(expr, 0);
    }

    public RoundDecimalExpression() {
    }

    public RoundDecimalExpression(List<Expression> children) {
        super(children);
        LiteralExpression scaleChild = (LiteralExpression)children.get(1);
        PDataType scaleType = scaleChild.getDataType();
        Object scaleValue = scaleChild.getValue();
        if (scaleValue != null) {
            int scale;
            if (scaleType.isCoercibleTo(PDataType.INTEGER, scaleValue) && (scale = ((Integer)PDataType.INTEGER.toObject(scaleValue, scaleType)).intValue()) >= 0 && scale <= 38) {
                this.scale = scale;
                return;
            }
            throw new IllegalDataException("Invalid second argument for scale: " + scaleValue + ". The scale must be between 0 and " + 38 + " inclusive.");
        }
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        Expression childExpr = (Expression)this.children.get(0);
        if (childExpr.evaluate(tuple, ptr)) {
            BigDecimal value = (BigDecimal)PDataType.DECIMAL.toObject(ptr, childExpr.getSortOrder());
            BigDecimal scaledValue = value.setScale(this.scale, this.getRoundingMode());
            ptr.set(this.getDataType().toBytes(scaledValue));
            return true;
        }
        return false;
    }

    @Override
    public PDataType getDataType() {
        return ((Expression)this.children.get(0)).getDataType();
    }

    protected RoundingMode getRoundingMode() {
        return RoundingMode.HALF_UP;
    }

    @Override
    public void readFields(DataInput input) throws IOException {
        super.readFields(input);
        this.scale = WritableUtils.readVInt(input);
    }

    @Override
    public void write(DataOutput output) throws IOException {
        super.write(output);
        WritableUtils.writeVInt(output, this.scale);
    }

    @Override
    public String getName() {
        return "ROUND";
    }

    @Override
    public FunctionExpression.OrderPreserving preservesOrder() {
        return FunctionExpression.OrderPreserving.YES;
    }
}

