/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.function;

import com.google.common.collect.Lists;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.CoerceExpression;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.expression.function.RoundDateExpression;
import org.apache.phoenix.expression.function.TimeUnit;
import org.apache.phoenix.schema.PDataType;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.tuple.Tuple;

public class RoundTimestampExpression
extends RoundDateExpression {
    private static final long HALF_OF_NANOS_IN_MILLI = java.util.concurrent.TimeUnit.MILLISECONDS.toNanos(1L) / 2L;

    public RoundTimestampExpression() {
    }

    private RoundTimestampExpression(List<Expression> children) {
        super(children);
    }

    public static Expression create(List<Expression> children) throws SQLException {
        Expression firstChild = children.get(0);
        PDataType firstChildDataType = firstChild.getDataType();
        String timeUnit = (String)((LiteralExpression)children.get(1)).getValue();
        LiteralExpression multiplierExpr = (LiteralExpression)children.get(2);
        if ((timeUnit == null || TimeUnit.MILLISECOND.toString().equalsIgnoreCase(timeUnit)) && ((Number)multiplierExpr.getValue()).intValue() == 1) {
            return new RoundTimestampExpression(children);
        }
        ArrayList<Expression> newChildren = Lists.newArrayListWithExpectedSize(children.size());
        newChildren.add(CoerceExpression.create(firstChild, firstChildDataType == PDataType.TIMESTAMP ? PDataType.DATE : PDataType.UNSIGNED_DATE));
        newChildren.addAll(children.subList(1, children.size()));
        return RoundDateExpression.create(newChildren);
    }

    @Override
    protected PDataType.PDataCodec getKeyRangeCodec(PDataType columnDataType) {
        return columnDataType == PDataType.TIMESTAMP ? PDataType.DATE.getCodec() : (columnDataType == PDataType.UNSIGNED_TIMESTAMP ? PDataType.UNSIGNED_DATE.getCodec() : super.getKeyRangeCodec(columnDataType));
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        if (((Expression)this.children.get(0)).evaluate(tuple, ptr)) {
            SortOrder sortOrder = ((Expression)this.children.get(0)).getSortOrder();
            PDataType dataType = this.getDataType();
            int nanos = dataType.getNanos(ptr, sortOrder);
            if ((long)nanos >= HALF_OF_NANOS_IN_MILLI) {
                long timeMillis = dataType.getMillis(ptr, sortOrder);
                Timestamp roundedTs = new Timestamp(timeMillis + 1L);
                byte[] byteValue = dataType.toBytes(roundedTs);
                ptr.set(byteValue);
            }
            return true;
        }
        return false;
    }
}

