/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.function;

import java.sql.SQLException;
import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.function.ScalarFunction;
import org.apache.phoenix.parse.FunctionParseNode;
import org.apache.phoenix.schema.PDataType;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.tuple.Tuple;

@FunctionParseNode.BuiltInFunction(name="SQLViewType", args={@FunctionParseNode.Argument(allowedTypes={PDataType.UNSIGNED_TINYINT})})
public class SQLViewTypeFunction
extends ScalarFunction {
    public static final String NAME = "SQLViewType";

    public SQLViewTypeFunction() {
    }

    public SQLViewTypeFunction(List<Expression> children) throws SQLException {
        super(children);
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        Expression child = (Expression)this.children.get(0);
        if (!child.evaluate(tuple, ptr)) {
            return false;
        }
        if (ptr.getLength() == 0) {
            return true;
        }
        PTable.ViewType viewType = PTable.ViewType.fromSerializedValue(ptr.get()[ptr.getOffset()]);
        ptr.set(viewType.getBytes());
        return true;
    }

    @Override
    public PDataType getDataType() {
        return PDataType.VARCHAR;
    }

    @Override
    public String getName() {
        return NAME;
    }
}

