/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.function;

import java.io.DataInput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.expression.aggregator.Aggregator;
import org.apache.phoenix.expression.function.AggregateFunction;
import org.apache.phoenix.expression.visitor.ExpressionVisitor;
import org.apache.phoenix.schema.PDataType;
import org.apache.phoenix.schema.tuple.Tuple;

public abstract class SingleAggregateFunction
extends AggregateFunction {
    private static final List<Expression> DEFAULT_EXPRESSION_LIST = Arrays.asList(LiteralExpression.newConstant((Object)1, true));
    protected boolean isConstant;
    private Aggregator aggregator;
    public static final Comparator<SingleAggregateFunction> SCHEMA_COMPARATOR = new Comparator<SingleAggregateFunction>(){

        @Override
        public int compare(SingleAggregateFunction o1, SingleAggregateFunction o2) {
            boolean isConstant2;
            boolean isNullable2;
            boolean isNullable1 = o1.isNullable();
            if (isNullable1 != (isNullable2 = o2.isNullable())) {
                return isNullable1 ? 1 : -1;
            }
            isNullable1 = o1.getAggregatorExpression().isNullable();
            if (isNullable1 != (isNullable2 = o2.getAggregatorExpression().isNullable())) {
                return isNullable1 ? 1 : -1;
            }
            boolean isConstant1 = o1.isConstantExpression();
            if (isConstant1 != (isConstant2 = o2.isConstantExpression())) {
                return isConstant1 ? 1 : -1;
            }
            PDataType r1 = o1.getAggregator().getDataType();
            PDataType r2 = o2.getAggregator().getDataType();
            if (r1.isFixedWidth() != r2.isFixedWidth()) {
                return r1.isFixedWidth() ? -1 : 1;
            }
            return r1.compareTo(r2);
        }
    };

    protected SingleAggregateFunction() {
        this(DEFAULT_EXPRESSION_LIST, true);
    }

    public SingleAggregateFunction(List<Expression> children) {
        this(children, children.get(0) instanceof LiteralExpression);
    }

    private SingleAggregateFunction(List<Expression> children, boolean isConstant) {
        super(children);
        this.isConstant = children.get(0) instanceof LiteralExpression;
        this.aggregator = this.newClientAggregator();
    }

    public boolean isConstantExpression() {
        return this.isConstant;
    }

    @Override
    public PDataType getDataType() {
        return ((Expression)this.children.get(0)).getDataType();
    }

    public Expression getAggregatorExpression() {
        return (Expression)this.children.get(0);
    }

    public Aggregator getAggregator() {
        return this.aggregator;
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        return this.getAggregator().evaluate(tuple, ptr);
    }

    public abstract Aggregator newServerAggregator(Configuration var1);

    public Aggregator newClientAggregator() {
        return this.newServerAggregator(null);
    }

    public Aggregator newServerAggregator(Configuration config, ImmutableBytesWritable ptr) {
        Aggregator agg = this.newServerAggregator(config);
        agg.aggregate(null, ptr);
        return agg;
    }

    public void readFields(DataInput input, Configuration conf) throws IOException {
        super.readFields(input);
        this.aggregator = this.newServerAggregator(conf);
    }

    @Override
    public boolean isNullable() {
        return true;
    }

    protected SingleAggregateFunction getDelegate() {
        return this;
    }

    @Override
    public final <T> T accept(ExpressionVisitor<T> visitor) {
        List<T> l;
        SingleAggregateFunction function = this.getDelegate();
        T t = visitor.visitLeave(function, l = this.acceptChildren(visitor, visitor.visitEnter(function)));
        if (t == null) {
            t = visitor.defaultReturn(function, l);
        }
        return t;
    }
}

