/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.function;

import java.math.BigDecimal;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.expression.aggregator.Aggregator;
import org.apache.phoenix.expression.aggregator.DecimalSumAggregator;
import org.apache.phoenix.expression.aggregator.DoubleSumAggregator;
import org.apache.phoenix.expression.aggregator.NumberSumAggregator;
import org.apache.phoenix.expression.function.CountAggregateFunction;
import org.apache.phoenix.expression.function.DelegateConstantToCountAggregateFunction;
import org.apache.phoenix.parse.FunctionParseNode;
import org.apache.phoenix.parse.SumAggregateParseNode;
import org.apache.phoenix.schema.PDataType;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.tuple.Tuple;

@FunctionParseNode.BuiltInFunction(name="SUM", nodeClass=SumAggregateParseNode.class, args={@FunctionParseNode.Argument(allowedTypes={PDataType.DECIMAL})})
public class SumAggregateFunction
extends DelegateConstantToCountAggregateFunction {
    public static final String NAME = "SUM";

    public SumAggregateFunction() {
    }

    public SumAggregateFunction(List<Expression> childExpressions) {
        super(childExpressions, null);
    }

    public SumAggregateFunction(List<Expression> childExpressions, CountAggregateFunction delegate) {
        super(childExpressions, delegate);
    }

    private Aggregator newAggregator(final PDataType type, SortOrder sortOrder, ImmutableBytesWritable ptr) {
        switch (type) {
            case DECIMAL: {
                return new DecimalSumAggregator(sortOrder, ptr);
            }
            case UNSIGNED_DOUBLE: 
            case UNSIGNED_FLOAT: 
            case DOUBLE: 
            case FLOAT: {
                return new DoubleSumAggregator(sortOrder, ptr){

                    @Override
                    protected PDataType getInputDataType() {
                        return type;
                    }
                };
            }
        }
        return new NumberSumAggregator(sortOrder, ptr){

            @Override
            protected PDataType getInputDataType() {
                return type;
            }
        };
    }

    @Override
    public Aggregator newClientAggregator() {
        return this.newAggregator(this.getDataType(), SortOrder.getDefault(), null);
    }

    @Override
    public Aggregator newServerAggregator(Configuration conf) {
        Expression child = this.getAggregatorExpression();
        return this.newAggregator(child.getDataType(), child.getSortOrder(), null);
    }

    @Override
    public Aggregator newServerAggregator(Configuration conf, ImmutableBytesWritable ptr) {
        Expression child = this.getAggregatorExpression();
        return this.newAggregator(child.getDataType(), child.getSortOrder(), ptr);
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        if (!super.evaluate(tuple, ptr)) {
            return false;
        }
        if (this.isConstantExpression()) {
            PDataType type = this.getDataType();
            Object constantValue = ((LiteralExpression)this.children.get(0)).getValue();
            if (type == PDataType.DECIMAL) {
                BigDecimal value = ((BigDecimal)constantValue).multiply((BigDecimal)PDataType.DECIMAL.toObject(ptr, PDataType.LONG));
                ptr.set(PDataType.DECIMAL.toBytes(value));
            } else {
                long constantLongValue = ((Number)constantValue).longValue();
                long value = constantLongValue * type.getCodec().decodeLong(ptr, SortOrder.getDefault());
                byte[] resultPtr = new byte[type.getByteSize().intValue()];
                type.getCodec().encodeLong(value, resultPtr, 0);
                ptr.set(resultPtr);
            }
        }
        return true;
    }

    @Override
    public PDataType getDataType() {
        switch (super.getDataType()) {
            case DECIMAL: {
                return PDataType.DECIMAL;
            }
            case UNSIGNED_DOUBLE: 
            case UNSIGNED_FLOAT: 
            case DOUBLE: 
            case FLOAT: {
                return PDataType.DOUBLE;
            }
        }
        return PDataType.LONG;
    }

    @Override
    public String getName() {
        return NAME;
    }
}

