/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.expression.function;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.SQLException;
import java.text.Format;
import java.text.ParseException;
import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.function.ScalarFunction;
import org.apache.phoenix.parse.FunctionParseNode;
import org.apache.phoenix.parse.ToDateParseNode;
import org.apache.phoenix.schema.PDataType;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.util.DateUtil;

@FunctionParseNode.BuiltInFunction(name="TO_DATE", nodeClass=ToDateParseNode.class, args={@FunctionParseNode.Argument(allowedTypes={PDataType.VARCHAR}), @FunctionParseNode.Argument(allowedTypes={PDataType.VARCHAR}, isConstant=true, defaultValue="null")})
public class ToDateFunction
extends ScalarFunction {
    public static final String NAME = "TO_DATE";
    private Format dateParser;
    private String dateFormat;

    public ToDateFunction() {
    }

    public ToDateFunction(List<Expression> children, String dateFormat, Format dateParser) throws SQLException {
        super(children.subList(0, 1));
        this.dateFormat = dateFormat;
        this.dateParser = dateParser;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.dateFormat.hashCode();
        result = 31 * result + this.getExpression().hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ToDateFunction other = (ToDateFunction)obj;
        if (!this.getExpression().equals(other.getExpression())) {
            return false;
        }
        return this.dateFormat.equals(other.dateFormat);
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
        Expression expression = this.getExpression();
        if (!expression.evaluate(tuple, ptr) || ptr.getLength() == 0) {
            return false;
        }
        PDataType type = expression.getDataType();
        String dateStr = (String)type.toObject(ptr, expression.getSortOrder());
        try {
            Object value = this.dateParser.parseObject(dateStr);
            byte[] byteValue = this.getDataType().toBytes(value);
            ptr.set(byteValue);
            return true;
        }
        catch (ParseException e) {
            throw new IllegalStateException("to_date('" + dateStr + ")' did not match expected date format of '" + this.dateFormat + "'.");
        }
    }

    @Override
    public PDataType getDataType() {
        return PDataType.DATE;
    }

    @Override
    public boolean isNullable() {
        return this.getExpression().isNullable();
    }

    @Override
    public void readFields(DataInput input) throws IOException {
        super.readFields(input);
        this.dateFormat = WritableUtils.readString(input);
        this.dateParser = DateUtil.getDateParser(this.dateFormat);
    }

    @Override
    public void write(DataOutput output) throws IOException {
        super.write(output);
        WritableUtils.writeString(output, this.dateFormat);
    }

    private Expression getExpression() {
        return (Expression)this.children.get(0);
    }

    @Override
    public String getName() {
        return NAME;
    }
}

