/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.filter;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Writables;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.query.QueryConstants;

public class ColumnProjectionFilter
extends FilterBase
implements Writable {
    private byte[] emptyCFName;
    private Map<ImmutableBytesPtr, NavigableSet<ImmutableBytesPtr>> columnsTracker;
    private Set<byte[]> conditionOnlyCfs;

    public ColumnProjectionFilter() {
    }

    public ColumnProjectionFilter(byte[] emptyCFName, Map<ImmutableBytesPtr, NavigableSet<ImmutableBytesPtr>> columnsTracker, Set<byte[]> conditionOnlyCfs) {
        this.emptyCFName = emptyCFName;
        this.columnsTracker = columnsTracker;
        this.conditionOnlyCfs = conditionOnlyCfs;
    }

    @Override
    public void readFields(DataInput input) throws IOException {
        int familyMapSize;
        this.emptyCFName = WritableUtils.readCompressedByteArray(input);
        assert (familyMapSize > 0);
        this.columnsTracker = new TreeMap<ImmutableBytesPtr, NavigableSet<ImmutableBytesPtr>>();
        for (familyMapSize = WritableUtils.readVInt(input); familyMapSize > 0; --familyMapSize) {
            int qualifiersSize;
            byte[] cf = WritableUtils.readCompressedByteArray(input);
            TreeSet<ImmutableBytesPtr> qualifiers = null;
            if (qualifiersSize > 0) {
                qualifiers = new TreeSet<ImmutableBytesPtr>();
                for (qualifiersSize = WritableUtils.readVInt(input); qualifiersSize > 0; --qualifiersSize) {
                    qualifiers.add(new ImmutableBytesPtr(WritableUtils.readCompressedByteArray(input)));
                }
            }
            this.columnsTracker.put(new ImmutableBytesPtr(cf), qualifiers);
        }
        this.conditionOnlyCfs = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
        for (int conditionOnlyCfsSize = WritableUtils.readVInt(input); conditionOnlyCfsSize > 0; --conditionOnlyCfsSize) {
            this.conditionOnlyCfs.add(WritableUtils.readCompressedByteArray(input));
        }
    }

    @Override
    public void write(DataOutput output) throws IOException {
        WritableUtils.writeCompressedByteArray(output, this.emptyCFName);
        WritableUtils.writeVInt(output, this.columnsTracker.size());
        for (Map.Entry<ImmutableBytesPtr, NavigableSet<ImmutableBytesPtr>> entry : this.columnsTracker.entrySet()) {
            WritableUtils.writeCompressedByteArray(output, entry.getKey().copyBytes());
            int qaulsSize = entry.getValue() == null ? 0 : entry.getValue().size();
            WritableUtils.writeVInt(output, qaulsSize);
            if (qaulsSize <= 0) continue;
            for (ImmutableBytesPtr cq : entry.getValue()) {
                WritableUtils.writeCompressedByteArray(output, cq.copyBytes());
            }
        }
        WritableUtils.writeVInt(output, this.conditionOnlyCfs.size());
        for (byte[] f : this.conditionOnlyCfs) {
            WritableUtils.writeCompressedByteArray(output, f);
        }
    }

    @Override
    public byte[] toByteArray() throws IOException {
        return Writables.getBytes((Writable)this);
    }

    public static ColumnProjectionFilter parseFrom(byte[] pbBytes) throws DeserializationException {
        try {
            return (ColumnProjectionFilter)Writables.getWritable(pbBytes, new ColumnProjectionFilter());
        }
        catch (IOException e) {
            throw new DeserializationException(e);
        }
    }

    @Override
    public void filterRow(List<KeyValue> kvs) {
        if (kvs.isEmpty()) {
            return;
        }
        KeyValue firstKV = kvs.get(0);
        Iterator<KeyValue> itr = kvs.iterator();
        while (itr.hasNext()) {
            KeyValue kv = itr.next();
            ImmutableBytesPtr f = new ImmutableBytesPtr(kv.getFamilyArray(), kv.getFamilyOffset(), kv.getFamilyLength());
            if (this.columnsTracker.containsKey(f)) {
                Set cols = this.columnsTracker.get(f);
                ImmutableBytesPtr q = new ImmutableBytesPtr(kv.getQualifierArray(), kv.getQualifierOffset(), kv.getQualifierLength());
                if (cols == null || cols.contains(q)) continue;
                itr.remove();
                continue;
            }
            itr.remove();
        }
        if (kvs.isEmpty()) {
            kvs.add(new KeyValue(firstKV.getRowArray(), firstKV.getRowOffset(), firstKV.getRowLength(), this.emptyCFName, 0, this.emptyCFName.length, QueryConstants.EMPTY_COLUMN_BYTES, 0, QueryConstants.EMPTY_COLUMN_BYTES.length, Long.MAX_VALUE, KeyValue.Type.Maximum, null, 0, 0));
        }
    }

    @Override
    public boolean hasFilterRow() {
        return true;
    }

    @Override
    public boolean isFamilyEssential(byte[] name) {
        return this.conditionOnlyCfs.isEmpty() || this.conditionOnlyCfs.contains(name);
    }

    @Override
    public String toString() {
        return "";
    }

    @Override
    public Filter.ReturnCode filterKeyValue(Cell ignored) throws IOException {
        return Filter.ReturnCode.INCLUDE;
    }
}

