/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.flume.serializer;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.flume.Context;
import org.apache.flume.conf.ComponentConfiguration;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.flume.DefaultKeyGenerator;
import org.apache.phoenix.flume.FlumeConstants;
import org.apache.phoenix.flume.KeyGenerator;
import org.apache.phoenix.flume.SchemaHandler;
import org.apache.phoenix.flume.serializer.EventSerializer;
import org.apache.phoenix.util.ColumnInfo;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseEventSerializer
implements EventSerializer {
    private static final Logger logger = LoggerFactory.getLogger(BaseEventSerializer.class);
    protected Connection connection;
    protected String fullTableName;
    protected ColumnInfo[] columnMetadata;
    protected boolean autoGenerateKey = false;
    protected KeyGenerator keyGenerator;
    protected List<String> colNames = Lists.newArrayListWithExpectedSize(10);
    protected List<String> headers = Lists.newArrayListWithExpectedSize(5);
    protected String upsertStatement;
    private String jdbcUrl;
    private Integer batchSize;
    private String createTableDdl;

    public void configure(Context context) {
        this.createTableDdl = context.getString("ddl");
        this.fullTableName = context.getString("table");
        String zookeeperQuorum = context.getString("zookeeperQuorum");
        String ipJdbcURL = context.getString("jdbcUrl");
        this.batchSize = context.getInteger("batchSize", FlumeConstants.DEFAULT_BATCH_SIZE);
        String columnNames = context.getString("columns");
        String headersStr = context.getString("headers");
        String keyGeneratorType = context.getString("rowkeyType");
        Preconditions.checkNotNull(this.fullTableName, "Table name cannot be empty, please specify in the configuration file");
        if (!Strings.isNullOrEmpty(zookeeperQuorum)) {
            this.jdbcUrl = QueryUtil.getUrl(zookeeperQuorum);
        }
        if (!Strings.isNullOrEmpty(ipJdbcURL)) {
            this.jdbcUrl = ipJdbcURL;
        }
        Preconditions.checkNotNull(this.jdbcUrl, "Please specify either the zookeeper quorum or the jdbc url in the configuration file");
        Preconditions.checkNotNull(columnNames, "Column names cannot be empty, please specify in configuration file");
        for (String s : Splitter.on(",").split(columnNames)) {
            this.colNames.add(s);
        }
        if (!Strings.isNullOrEmpty(headersStr)) {
            for (String s : Splitter.on(",").split(headersStr)) {
                this.headers.add(s);
            }
        }
        if (!Strings.isNullOrEmpty(keyGeneratorType)) {
            try {
                this.keyGenerator = DefaultKeyGenerator.valueOf(keyGeneratorType.toUpperCase());
                this.autoGenerateKey = true;
            }
            catch (IllegalArgumentException iae) {
                logger.error("An invalid key generator {} was specified in configuration file. Specify one of {}", (Object)keyGeneratorType, (Object)DefaultKeyGenerator.values());
                Throwables.propagate(iae);
            }
        }
        logger.debug(" the jdbcUrl configured is {}", (Object)this.jdbcUrl);
        logger.debug(" columns configured are {}", (Object)this.colNames.toString());
        logger.debug(" headers configured are {}", (Object)headersStr);
        logger.debug(" the keyGenerator configured is {} ", (Object)keyGeneratorType);
        this.doConfigure(context);
    }

    public void configure(ComponentConfiguration conf) {
    }

    @Override
    public void initialize() throws SQLException {
        Properties props = new Properties();
        props.setProperty("UpsertBatchSize", String.valueOf(this.batchSize));
        ResultSet rs = null;
        try {
            this.connection = DriverManager.getConnection(this.jdbcUrl, props);
            this.connection.setAutoCommit(false);
            if (this.createTableDdl != null) {
                SchemaHandler.createTable(this.connection, this.createTableDdl);
            }
            LinkedHashMap<String, Integer> qualifiedColumnMap = Maps.newLinkedHashMap();
            LinkedHashMap<String, Integer> unqualifiedColumnMap = Maps.newLinkedHashMap();
            String schemaName = SchemaUtil.getSchemaNameFromFullName(this.fullTableName);
            String tableName = SchemaUtil.getTableNameFromFullName(this.fullTableName);
            String rowkey = null;
            String cq = null;
            String cf = null;
            Integer dt = null;
            rs = this.connection.getMetaData().getColumns("", StringUtil.escapeLike(SchemaUtil.normalizeIdentifier(schemaName)), StringUtil.escapeLike(SchemaUtil.normalizeIdentifier(tableName)), null);
            while (rs.next()) {
                cf = rs.getString(24);
                cq = rs.getString(4);
                dt = rs.getInt(5);
                if (Strings.isNullOrEmpty(cf)) {
                    rowkey = cq;
                } else {
                    qualifiedColumnMap.put(SchemaUtil.getColumnDisplayName(cf, cq), dt);
                }
                unqualifiedColumnMap.put(SchemaUtil.getColumnDisplayName(null, cq), dt);
            }
            if (unqualifiedColumnMap.isEmpty()) {
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.TABLE_UNDEFINED).setTableName(tableName).build().buildException();
            }
            int colSize = this.colNames.size();
            int headersSize = this.headers.size();
            int totalSize = colSize + headersSize + (this.autoGenerateKey ? 1 : 0);
            this.columnMetadata = new ColumnInfo[totalSize];
            int position = 0;
            position = this.addToColumnMetadataInfo(this.colNames, qualifiedColumnMap, unqualifiedColumnMap, position);
            position = this.addToColumnMetadataInfo(this.headers, qualifiedColumnMap, unqualifiedColumnMap, position);
            if (this.autoGenerateKey) {
                Integer sqlType = (Integer)unqualifiedColumnMap.get(rowkey);
                if (sqlType == null) {
                    throw new SQLExceptionInfo.Builder(SQLExceptionCode.PRIMARY_KEY_MISSING).setColumnName(rowkey).setTableName(this.fullTableName).build().buildException();
                }
                this.columnMetadata[position] = new ColumnInfo(rowkey, sqlType);
                ++position;
            }
            this.upsertStatement = QueryUtil.constructUpsertStatement(this.fullTableName, Arrays.asList(this.columnMetadata));
            logger.info(" the upsert statement is {} ", (Object)this.upsertStatement);
        }
        catch (SQLException e) {
            logger.error("error {} occurred during initializing connection ", (Object)e.getMessage());
            throw e;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
        this.doInitialize();
    }

    private int addToColumnMetadataInfo(List<String> columns, Map<String, Integer> qualifiedColumnsInfoMap, Map<String, Integer> unqualifiedColumnsInfoMap, int position) throws SQLException {
        Preconditions.checkNotNull(columns);
        Preconditions.checkNotNull(qualifiedColumnsInfoMap);
        Preconditions.checkNotNull(unqualifiedColumnsInfoMap);
        for (int i = 0; i < columns.size(); ++i) {
            String columnName = SchemaUtil.normalizeIdentifier(columns.get(i).trim());
            Integer sqlType = unqualifiedColumnsInfoMap.get(columnName);
            if (sqlType == null && (sqlType = qualifiedColumnsInfoMap.get(columnName)) == null) {
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.COLUMN_NOT_FOUND).setColumnName(columnName).setTableName(this.fullTableName).build().buildException();
            }
            this.columnMetadata[position] = new ColumnInfo(columnName, sqlType);
            ++position;
        }
        return position;
    }

    public abstract void doConfigure(Context var1);

    public abstract void doInitialize() throws SQLException;

    @Override
    public void close() {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (SQLException e) {
                logger.error(" Error while closing connection {} ");
            }
        }
    }
}

