/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.flume.serializer;

import com.google.common.base.Preconditions;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.flume.Context;
import org.apache.flume.Event;
import org.apache.phoenix.flume.serializer.BaseEventSerializer;
import org.apache.phoenix.schema.PDataType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegexEventSerializer
extends BaseEventSerializer {
    private static final Logger logger = LoggerFactory.getLogger(RegexEventSerializer.class);
    private Pattern inputPattern;

    @Override
    public void doConfigure(Context context) {
        String regex = context.getString("regex", "(.*)");
        boolean regexIgnoreCase = context.getBoolean("regexIgnoreCase", Boolean.valueOf(false));
        this.inputPattern = Pattern.compile(regex, 32 + (regexIgnoreCase ? 2 : 0));
    }

    @Override
    public void doInitialize() throws SQLException {
    }

    @Override
    public void upsertEvents(List<Event> events) throws SQLException {
        Preconditions.checkNotNull(events);
        Preconditions.checkNotNull(this.connection);
        Preconditions.checkNotNull(this.upsertStatement);
        PreparedStatement colUpsert = this.connection.prepareStatement(this.upsertStatement);
        boolean wasAutoCommit = this.connection.getAutoCommit();
        this.connection.setAutoCommit(false);
        String value = null;
        Integer sqlType = null;
        try {
            for (Event event : events) {
                byte[] payloadBytes = event.getBody();
                if (payloadBytes == null || payloadBytes.length == 0) continue;
                String payload = new String(payloadBytes);
                Matcher m = this.inputPattern.matcher(payload.trim());
                if (!m.matches()) {
                    logger.debug("payload {} doesn't match the pattern {} ", (Object)payload, (Object)this.inputPattern.toString());
                    continue;
                }
                if (m.groupCount() != this.colNames.size()) {
                    logger.debug("payload {} size doesn't match the pattern {} ", m.groupCount(), (Object)this.colNames.size());
                    continue;
                }
                int index = 1;
                int offset = 0;
                int i = 0;
                while (i < this.colNames.size()) {
                    if (this.columnMetadata[offset] != null) {
                        value = m.group(i + 1);
                        sqlType = this.columnMetadata[offset].getSqlType();
                        Object upsertValue = PDataType.fromTypeId(sqlType).toObject(value);
                        if (upsertValue != null) {
                            colUpsert.setObject(index++, upsertValue, sqlType);
                        } else {
                            colUpsert.setNull(index++, sqlType);
                        }
                    }
                    ++i;
                    ++offset;
                }
                Map headerValues = event.getHeaders();
                int i2 = 0;
                while (i2 < this.headers.size()) {
                    String headerName = (String)this.headers.get(i2);
                    String headerValue = (String)headerValues.get(headerName);
                    sqlType = this.columnMetadata[offset].getSqlType();
                    Object upsertValue = PDataType.fromTypeId(sqlType).toObject(headerValue);
                    if (upsertValue != null) {
                        colUpsert.setObject(index++, upsertValue, sqlType);
                    } else {
                        colUpsert.setNull(index++, sqlType);
                    }
                    ++i2;
                    ++offset;
                }
                if (this.autoGenerateKey) {
                    sqlType = this.columnMetadata[offset].getSqlType();
                    String generatedRowValue = this.keyGenerator.generate();
                    Object rowkeyValue = PDataType.fromTypeId(sqlType).toObject(generatedRowValue);
                    colUpsert.setObject(index++, rowkeyValue, sqlType);
                }
                colUpsert.execute();
            }
            this.connection.commit();
        }
        catch (Exception ex) {
            logger.error("An error {} occurred during persisting the event ", (Object)ex.getMessage());
            throw new SQLException(ex.getMessage());
        }
        finally {
            if (wasAutoCommit) {
                this.connection.setAutoCommit(true);
            }
        }
    }
}

